/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.configuration;

import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.sonar.commons.configuration.Property;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDatabaseConfiguration
extends BaseConfiguration {
    private DatabaseSession session;
    private Resource resource;

    public ResourceDatabaseConfiguration(DatabaseSession session, Resource resource) {
        this.session = session;
        this.resource = resource;
        this.load();
    }

    public void load() {
        this.clear();
        this.loadGlobalProperties();
        this.loadResourceProperties();
    }

    private void loadResourceProperties() {
        if (this.resource != null && this.resource.getId() != null) {
            List properties = this.session.createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId=:resourceId").setParameter("resourceId", (Object)this.resource.getId()).getResultList();
            this.registerProperties(properties);
        }
    }

    private void registerProperties(List<Property> properties) {
        if (properties != null) {
            for (Property property : properties) {
                this.setProperty(property.getKey(), property.getValue());
            }
        }
    }

    private void loadGlobalProperties() {
        List properties = this.session.createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId is null").getResultList();
        this.registerProperties(properties);
    }
}

