/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.PersistenceException;
import org.apache.commons.configuration.Configuration;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.commons.database.DatabaseConnector;
import org.sonar.commons.database.WrongDatabaseVersionException;
import org.sonar.commons.database.dialect.DerbyWithDecimalDialect;
import org.sonar.commons.database.dialect.MsSqlDialect;
import org.sonar.commons.database.dialect.MySqlWithDecimalDialect;
import org.sonar.commons.database.dialect.Oracle10gWithDecimalDialect;

public abstract class AbstractDatabaseConnector
implements DatabaseConnector {
    protected static final Logger LOG_SQL = LoggerFactory.getLogger((String)"org.hibernate.SQL");
    protected static final Logger LOG_STATISTICS = LoggerFactory.getLogger((String)"org.sonar.DBSTATISTICS");
    private Configuration configuration = null;
    private int databaseVersion = -1;

    protected AbstractDatabaseConnector(Configuration configuration) {
        this.configuration = configuration;
    }

    protected AbstractDatabaseConnector() {
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void dumpStatistics() {
        if (LOG_STATISTICS.isInfoEnabled() && this.getEntityManagerFactory() instanceof EntityManagerFactoryImpl) {
            HibernateEntityManagerFactory hibernateFactory = (HibernateEntityManagerFactory)this.getEntityManagerFactory();
            Statistics stats = hibernateFactory.getSessionFactory().getStatistics();
            for (String query : stats.getQueries()) {
                QueryStatistics stat = stats.getQueryStatistics(query);
                StringBuilder sb = new StringBuilder();
                sb.append(stats.getQueryExecutionMaxTime());
                sb.append("ms, count=");
                sb.append(stat.getExecutionCount());
                sb.append(", sql=");
                sb.append(stat.getCategoryName());
                LOG_STATISTICS.info(sb.toString());
            }
            stats.clear();
        }
    }

    private int loadVersion() {
        block38: {
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            ResultSet tablesRs = null;
            try {
                connection = this.getConnection();
                tablesRs = connection.getMetaData().getTables(null, null, "%", null);
                boolean tableExists = false;
                while (tablesRs.next()) {
                    if (!"schema_info".equalsIgnoreCase(tablesRs.getString(3))) continue;
                    tableExists = true;
                    break;
                }
                if (!tableExists) break block38;
                stmt = connection.createStatement();
                try {
                    rs = stmt.executeQuery("SELECT version FROM schema_info");
                    if (rs.next()) {
                        int n = rs.getInt(1);
                        return n;
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                throw new PersistenceException("Can not check the database version", (Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (tablesRs != null) {
                    try {
                        tablesRs.close();
                    }
                    catch (SQLException e) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
        return -1;
    }

    protected boolean checkSchemaVersion() {
        if (this.databaseVersion == 62) {
            return true;
        }
        this.databaseVersion = this.loadVersion();
        return this.databaseVersion == 62;
    }

    public void checkVersion() throws WrongDatabaseVersionException {
        if (!this.checkSchemaVersion()) {
            throw new WrongDatabaseVersionException(this.databaseVersion, 62);
        }
    }

    public String getDialect() {
        String dialect = this.configuration.getString("sonar.jdbc.dialect");
        if (dialect == null) {
            Connection connection = null;
            try {
                connection = this.getConnection();
                dialect = this.getDialectFromJdbcUrl(connection.getMetaData().getURL());
            }
            catch (SQLException e) {
                throw new PersistenceException("can not autodetect the dialect", (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return dialect;
    }

    public String getDialectClass(String dialect) {
        String dialectClass = this.configuration.getString("sonar.jdbc.dialectClass");
        if (dialectClass == null) {
            dialectClass = this.getHibernateDialectClassName(dialect);
        }
        return dialectClass;
    }

    private String getDialectFromJdbcUrl(String url) {
        if (url.toLowerCase().startsWith("jdbc:db2:")) {
            return "db2";
        }
        if (url.toLowerCase().startsWith("jdbc:derby:")) {
            return "derby";
        }
        if (url.toLowerCase().startsWith("jdbc:hsqldb:")) {
            return "hsqldb";
        }
        if (url.toLowerCase().startsWith("jdbc:microsoft:sqlserver:") || url.toLowerCase().startsWith("jdbc:jtds:sqlserver:")) {
            return "mssql";
        }
        if (url.toLowerCase().startsWith("jdbc:mysql:")) {
            return "mysql";
        }
        if (url.toLowerCase().startsWith("jdbc:oracle:")) {
            return "oracle";
        }
        if (url.toLowerCase().startsWith("jdbc:postgresql:")) {
            return "postgresql";
        }
        return null;
    }

    private String getHibernateDialectClassName(String dialect) {
        if ("db2".equals(dialect)) {
            return DB2Dialect.class.getName();
        }
        if ("derby".equals(dialect)) {
            return DerbyWithDecimalDialect.class.getName();
        }
        if ("hsqldb".equals(dialect)) {
            return HSQLDialect.class.getName();
        }
        if ("mssql".equals(dialect)) {
            return MsSqlDialect.class.getName();
        }
        if ("mysql".equals(dialect)) {
            return MySqlWithDecimalDialect.class.getName();
        }
        if ("oracle".equals(dialect)) {
            return Oracle10gWithDecimalDialect.class.getName();
        }
        if ("postgresql".equals(dialect)) {
            return PostgreSQLDialect.class.getName();
        }
        return null;
    }
}

