/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.database;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.commons.database.DatabaseConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSession {
    public static final int BATCH_SIZE = 100;
    private DatabaseConnector connector;
    private EntityManager entityManager = null;
    private int index = 0;
    private boolean inTransaction = false;

    public DatabaseSession(DatabaseConnector connector) {
        this.connector = connector;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void start() {
        this.entityManager = this.connector.createEntityManager();
        this.index = 0;
    }

    public void stop() {
        this.commit();
        if (this.entityManager != null && this.entityManager.isOpen()) {
            this.entityManager.clear();
            this.entityManager.close();
            this.entityManager = null;
        }
    }

    public void commit() {
        if (this.entityManager != null && this.inTransaction) {
            if (this.entityManager.isOpen()) {
                if (this.entityManager.getTransaction().getRollbackOnly()) {
                    this.entityManager.getTransaction().rollback();
                } else {
                    this.entityManager.getTransaction().commit();
                }
            }
            this.inTransaction = false;
            this.index = 0;
        }
    }

    public void rollback() {
        if (this.entityManager != null && this.inTransaction) {
            this.entityManager.getTransaction().rollback();
            this.inTransaction = false;
            this.index = 0;
        }
    }

    public Object save(Object model) {
        this.startTransaction();
        this.internalSave(model, true);
        return model;
    }

    public Object saveWithoutFlush(Object model) {
        this.startTransaction();
        this.internalSave(model, false);
        return model;
    }

    public boolean contains(Object model) {
        this.startTransaction();
        return this.entityManager.contains(model);
    }

    public void save(Object ... models) {
        this.startTransaction();
        for (Object model : models) {
            this.save(model);
        }
    }

    private void internalSave(Object model, boolean flushIfNeeded) {
        this.entityManager.persist(model);
        if (flushIfNeeded && ++this.index % 100 == 0) {
            this.flush();
        }
    }

    public Object merge(Object model) {
        this.startTransaction();
        return this.entityManager.merge(model);
    }

    public void remove(Object model) {
        this.startTransaction();
        this.entityManager.remove(model);
        if (++this.index % 100 == 0) {
            this.flush();
        }
    }

    public <T> T reattach(Class<T> entityClass, Object primaryKey) {
        this.startTransaction();
        return (T)this.entityManager.getReference(entityClass, primaryKey);
    }

    private void startTransaction() {
        if (!this.inTransaction) {
            this.entityManager.getTransaction().begin();
            this.inTransaction = true;
        }
    }

    private void flush() {
        this.entityManager.flush();
        this.entityManager.clear();
    }

    public Query createQuery(String hql) {
        this.startTransaction();
        return this.entityManager.createQuery(hql);
    }

    public <T> T getSingleResult(Query query, T defaultValue) {
        try {
            return (T)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return defaultValue;
        }
    }

    public <T> T getEntity(Class<T> entityClass, Object id) {
        this.startTransaction();
        return (T)this.getEntityManager().find(entityClass, id);
    }

    public <T> T getSingleResult(Class<T> entityClass, Object ... criterias) {
        try {
            return (T)this.getSingleResult(this.getQueryForCriterias(entityClass, true, criterias), null);
        }
        catch (NonUniqueResultException ex) {
            LoggerFactory.getLogger(DatabaseSession.class).warn("NonUniqueResultException on entity {} with criterias : {}", (Object)entityClass.getSimpleName(), (Object)StringUtils.join((Object[])criterias, (String)","));
            throw ex;
        }
    }

    public <T> List<T> getResults(Class<T> entityClass, Object ... criterias) {
        return this.getQueryForCriterias(entityClass, true, criterias).getResultList();
    }

    public <T> List<T> getResults(Class<T> entityClass) {
        return this.getQueryForCriterias(entityClass, false, null).getResultList();
    }

    private Query getQueryForCriterias(Class<?> entityClass, boolean raiseError, Object ... criterias) {
        if (criterias == null && raiseError) {
            throw new IllegalStateException("criterias parameter must be provided");
        }
        this.startTransaction();
        StringBuilder hql = new StringBuilder("SELECT o FROM ").append(entityClass.getSimpleName()).append(" o");
        if (criterias != null) {
            hql.append(" WHERE ");
            HashMap<String, Object> mappedCriterias = new HashMap<String, Object>();
            for (int i = 0; i < criterias.length; i += 2) {
                mappedCriterias.put((String)criterias[i], criterias[i + 1]);
            }
            Iterator i = mappedCriterias.keySet().iterator();
            while (i.hasNext()) {
                String criteria = (String)i.next();
                hql.append("o.").append(criteria).append("=:").append(criteria);
                if (!i.hasNext()) continue;
                hql.append(" AND ");
            }
            Query query = this.getEntityManager().createQuery(hql.toString());
            for (String criteria : mappedCriterias.keySet()) {
                query.setParameter(criteria, mappedCriterias.get(criteria));
            }
            return query;
        }
        return this.getEntityManager().createQuery(hql.toString());
    }
}

