/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration.Configuration;
import org.sonar.commons.database.AbstractDatabaseConnector;
import org.sonar.commons.database.StatisticsEntityManager;

public class DriverDatabaseConnector
extends AbstractDatabaseConnector {
    private EntityManagerFactory factory = null;
    private boolean operational = false;
    protected String hbm2ddl = "validate";

    public DriverDatabaseConnector(Configuration configuration) {
        super(configuration);
    }

    public boolean isOperational() {
        return this.operational;
    }

    public void start() {
        if (!this.operational) {
            this.checkVersion();
            this.getEntityManagerFactory();
            this.operational = true;
        }
    }

    public void stop() {
        if (this.factory != null && this.factory.isOpen()) {
            this.factory.close();
            this.factory = null;
        }
        this.operational = false;
    }

    public String getDriver() {
        return this.getConfiguration().getString("sonar.jdbc.driver");
    }

    public String getUrl() {
        return this.getConfiguration().getString("sonar.jdbc.url");
    }

    public String getUsername() {
        return this.getConfiguration().getString("sonar.jdbc.user");
    }

    public String getPassword() {
        return this.getConfiguration().getString("sonar.jdbc.password");
    }

    public int getIsolationLevel() {
        return this.getConfiguration().getInt("sonar.jdbc.defaultTransactionIsolation", 1);
    }

    public Connection getConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("SQL driver not found " + this.getDriver());
        }
        return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
    }

    public void setHbm2ddl(String s) {
        this.hbm2ddl = s;
    }

    public synchronized EntityManagerFactory getEntityManagerFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        Properties props = new Properties();
        props.put("hibernate.connection.isolation", (Object)this.getIsolationLevel());
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddl);
        props.put("hibernate.connection.url", this.getUrl());
        props.put("hibernate.connection.driver_class", this.getDriver());
        props.put("hibernate.connection.username", this.getUsername());
        props.put("hibernate.dialect", this.getDialectClass(this.getDialect()));
        if (this.getPassword() != null) {
            props.put("hibernate.connection.password", this.getPassword());
        }
        if (LOG_STATISTICS.isInfoEnabled()) {
            props.put("hibernate.generate_statistics", "true");
        }
        if (LOG_SQL.isInfoEnabled()) {
            props.put("hibernate.show_sql", "true");
        }
        if (this.getConfiguration().getBoolean("sonar.jdbc.hibernateSecondLevelCache", true)) {
            props.put("hibernate.cache.provider_class", "org.hibernate.cache.EhCacheProvider");
            props.put("hibernate.cache.use_second_level_cache", "true");
            props.put("hibernate.cache.use_query_cache", "false");
        } else {
            props.put("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
            props.put("hibernate.cache.use_second_level_cache", "false");
            props.put("hibernate.cache.use_query_cache", "false");
        }
        this.factory = Persistence.createEntityManagerFactory((String)"sonar", (Map)props);
        return this.factory;
    }

    public EntityManager createEntityManager() {
        EntityManager manager = this.getEntityManagerFactory().createEntityManager();
        if (LOG_STATISTICS.isInfoEnabled()) {
            manager = new StatisticsEntityManager(manager, LOG_STATISTICS);
        }
        return manager;
    }
}

