/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.database;

import javax.persistence.EntityManager;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.sonar.commons.database.DriverDatabaseConnector;
import org.sonar.commons.database.SchemaInfo;

public class InMemoryDatabaseConnector
extends DriverDatabaseConnector {
    public static final String DRIVER = "org.hsqldb.jdbcDriver";
    public static final String URL = "jdbc:hsqldb:mem:sonar";
    public static final String USER = "sa";
    public static final String PASSWORD = null;
    public static final int ISOLATION = 1;
    private int version = -1;

    public InMemoryDatabaseConnector(int version, boolean createSchema) {
        this(InMemoryDatabaseConnector.getInMemoryConfiguration(), version, createSchema);
    }

    public InMemoryDatabaseConnector() {
        this(InMemoryDatabaseConnector.getInMemoryConfiguration(), 62, true);
    }

    public InMemoryDatabaseConnector(Configuration configuration, int version, boolean createSchema) {
        super(configuration);
        this.version = version;
        if (createSchema) {
            this.setHbm2ddl("create-drop");
        }
    }

    protected static Configuration getInMemoryConfiguration() {
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.setProperty("sonar.jdbc.url", (Object)URL);
        conf.setProperty("sonar.jdbc.driver", (Object)DRIVER);
        conf.setProperty("sonar.jdbc.user", (Object)USER);
        conf.setProperty("sonar.jdbc.password", (Object)PASSWORD);
        conf.setProperty("sonar.jdbc.defaultTransactionIsolation", (Object)1);
        conf.setProperty("sonar.jdbc.hibernateSecondLevelCache", (Object)false);
        return conf;
    }

    public void start() {
        if (this.version >= 0) {
            this.getEntityManagerFactory();
            this.populateDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatabase() {
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setVersion(this.version);
        EntityManager manager = null;
        try {
            manager = this.createEntityManager();
            manager.getTransaction().begin();
            manager.persist((Object)schemaInfo);
            manager.getTransaction().commit();
        }
        finally {
            if (manager != null) {
                manager.close();
            }
        }
    }
}

