/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.database;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsEntityManager
implements EntityManager {
    private final EntityManager manager;
    private final Logger logger;
    private EntityTransaction transaction;

    public StatisticsEntityManager(EntityManager manager, Logger logger) {
        this.manager = manager;
        this.logger = logger;
    }

    public void clear() {
        this.manager.clear();
    }

    public void close() {
        this.manager.close();
    }

    public boolean contains(Object entity) {
        return this.manager.contains(entity);
    }

    public Query createNamedQuery(String name) {
        return this.manager.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        return this.manager.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.manager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.manager.createNativeQuery(sqlString, resultSetMapping);
    }

    public Query createQuery(String qlString) {
        return this.manager.createQuery(qlString);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        long start = System.currentTimeMillis();
        Object hit = this.manager.find(entityClass, primaryKey);
        long stop = System.currentTimeMillis() - start;
        this.logger.info("Find took " + stop + " ms");
        return (T)hit;
    }

    public void flush() {
        long start = System.currentTimeMillis();
        this.manager.flush();
        long stop = System.currentTimeMillis() - start;
        this.logger.info("Flush took " + stop + " ms");
    }

    public Object getDelegate() {
        return this.manager.getDelegate();
    }

    public FlushModeType getFlushMode() {
        return this.manager.getFlushMode();
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.manager.getReference(entityClass, primaryKey);
    }

    public EntityTransaction getTransaction() {
        if (this.transaction == null) {
            this.transaction = new EntityTransaction(){
                private long begin;

                public void begin() {
                    this.begin = System.currentTimeMillis();
                    StatisticsEntityManager.this.manager.getTransaction().begin();
                }

                public void commit() {
                    long start = System.currentTimeMillis();
                    StatisticsEntityManager.this.manager.getTransaction().commit();
                    long commitTimeTaken = System.currentTimeMillis() - start;
                    long transactionTimeTaken = System.currentTimeMillis() - this.begin;
                    StatisticsEntityManager.this.logger.info("Commit took " + commitTimeTaken + " ms, global transaction took " + transactionTimeTaken + " ms");
                    this.begin = 0L;
                }

                public boolean getRollbackOnly() {
                    return StatisticsEntityManager.this.manager.getTransaction().getRollbackOnly();
                }

                public boolean isActive() {
                    return StatisticsEntityManager.this.manager.getTransaction().isActive();
                }

                public void rollback() {
                    long start = System.currentTimeMillis();
                    StatisticsEntityManager.this.manager.getTransaction().rollback();
                    long rollbackTimeTaken = System.currentTimeMillis() - start;
                    long transactionTimeTaken = System.currentTimeMillis() - this.begin;
                    StatisticsEntityManager.this.logger.info("Rollback took " + rollbackTimeTaken + " ms, global transaction took " + transactionTimeTaken + " ms");
                    this.begin = 0L;
                }

                public void setRollbackOnly() {
                    StatisticsEntityManager.this.manager.getTransaction().setRollbackOnly();
                }
            };
        }
        return this.transaction;
    }

    public boolean isOpen() {
        return this.manager.isOpen();
    }

    public void joinTransaction() {
        this.manager.joinTransaction();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.manager.lock(entity, lockMode);
    }

    public <T> T merge(T entity) {
        return (T)this.manager.merge(entity);
    }

    public void persist(Object entity) {
        this.manager.persist(entity);
    }

    public void refresh(Object entity) {
        this.manager.refresh(entity);
    }

    public void remove(Object entity) {
        this.manager.remove(entity);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.manager.setFlushMode(flushMode);
    }
}

