/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.database;

import org.sonar.commons.database.DatabaseConnector;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.database.DatabaseSessionFactory;

public class ThreadLocalDatabaseSessionFactory
implements DatabaseSessionFactory {
    private ThreadLocal<DatabaseSession> threadSession = new ThreadLocal();
    private DatabaseConnector connector;

    public ThreadLocalDatabaseSessionFactory(DatabaseConnector connector) {
        this.connector = connector;
    }

    public DatabaseSession getSession() {
        DatabaseSession session = this.threadSession.get();
        if (session == null) {
            session = new DatabaseSession(this.connector);
            session.start();
            this.threadSession.set(session);
        }
        return session;
    }

    public void clear() {
        DatabaseSession session = this.threadSession.get();
        if (session != null) {
            session.stop();
        }
        this.threadSession.set(null);
    }

    public void stop() {
        this.clear();
    }
}

