/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.events;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.commons.resources.Resource;
import org.sonar.commons.resources.Snapshot;

@Entity
@Table(name="events")
public class Event {
    public static final String CATEGORY_VERSION = "Version";
    public static final String CATEGORY_ALERT = "Alert";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="EVENTS_SEQ", sequenceName="EVENTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="EVENTS_SEQ")
    private Integer id;
    @Column(name="name", updatable=true, nullable=true, length=50)
    private String name;
    @Column(name="description", updatable=true, nullable=true, length=3072)
    private String description;
    @Column(name="category", updatable=true, nullable=true, length=50)
    private String category;
    @Column(name="event_date", updatable=true, nullable=false)
    private Date date;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="snapshot_id", updatable=true, nullable=true)
    private Snapshot snapshot;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="resource_id", updatable=false, nullable=true)
    private Resource resource;

    public Event() {
    }

    public Event(String name, String description, String category, Date date, Resource resource) {
        this.name = name;
        this.description = description;
        this.category = category;
        this.date = date;
        this.resource = resource;
    }

    public Event(String name, String description, String category, Snapshot snapshot) {
        this.name = name;
        this.description = description;
        this.category = category;
        this.setSnapshot(snapshot);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isVersionCategory() {
        return CATEGORY_VERSION.equalsIgnoreCase(this.category);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
        if (snapshot != null) {
            this.date = snapshot.getCreatedAt();
            this.resource = snapshot.getResource();
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("categ", (Object)this.category).append("date", (Object)this.date).append("snap", (Object)this.snapshot).append("res", (Object)this.resource).toString();
    }

    public boolean isLinkedToSnapshot() {
        return this.snapshot != null;
    }
}

