/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.measures;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.commons.resources.Measure;

@Entity
@Table(name="async_measure_snapshots")
public class AsyncMeasureSnapshot {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="ASYNC_MEASURE_SNAPSHOTS_SEQ", sequenceName="ASYNC_MEASURE_SNAPSHOTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="ASYNC_MEASURE_SNAPSHOTS_SEQ")
    private Integer id;
    @Column(name="project_measure_id", updatable=true, nullable=true)
    private Integer measureId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="measure_date", updatable=true, nullable=true)
    private Date measureDate;
    @Column(name="snapshot_id", updatable=true, nullable=true)
    private Integer snapshotId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="snapshot_date", updatable=true, nullable=true)
    private Date snapshotDate;
    @Column(name="metric_id", updatable=true, nullable=true)
    private Integer metricId;
    @Column(name="project_id", updatable=true, nullable=true)
    private Integer projectId;

    public AsyncMeasureSnapshot(Integer measureId, Integer snapshotId, Date measureDate, Date snapshotDate, Integer metricId, Integer projectId) {
        this.measureId = measureId;
        this.measureDate = measureDate;
        this.snapshotId = snapshotId;
        this.snapshotDate = snapshotDate;
        this.projectId = projectId;
        this.metricId = metricId;
    }

    public AsyncMeasureSnapshot() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getMeasureId() {
        return this.measureId;
    }

    public void setMeasureId(Integer measureId) {
        this.measureId = measureId;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Integer snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Date getMeasureDate() {
        return this.measureDate;
    }

    public void setMeasureDate(Date measureDate) {
        this.measureDate = measureDate;
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public void setSnapshotDate(Date snapshotDate) {
        this.snapshotDate = snapshotDate;
    }

    public Integer getMetricId() {
        return this.metricId;
    }

    public void setMetricId(Integer metricId) {
        this.metricId = metricId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setMeasure(Measure measure) {
        this.setMeasureId(measure.getId());
        this.setMeasureDate(measure.getMeasureDate());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AsyncMeasureSnapshot)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsyncMeasureSnapshot other = (AsyncMeasureSnapshot)obj;
        return new EqualsBuilder().append((Object)this.measureId, (Object)other.getMeasureId()).append((Object)this.measureDate, (Object)other.getMeasureDate()).append((Object)this.snapshotId, (Object)other.getSnapshotId()).append((Object)this.snapshotDate, (Object)other.getSnapshotDate()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.measureId).append((Object)this.measureDate).append((Object)this.snapshotDate).append((Object)this.snapshotId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("measureId", (Object)this.measureId).append("measureDate", (Object)this.measureDate).append("snapshotId", (Object)this.snapshotId).append("snapshotDate", (Object)this.snapshotDate).toString();
    }
}

