/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.measures;

import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.sonar.commons.BaseDao;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.measures.AsyncMeasureSnapshot;
import org.sonar.commons.resources.Measure;
import org.sonar.commons.resources.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncMeasuresDao
extends BaseDao {
    public AsyncMeasuresDao(DatabaseSession session) {
        super(session);
    }

    public Measure getAsyncMeasure(Integer AsyncMeasureId) {
        return (Measure)this.getSession().getEntityManager().find(Measure.class, (Object)AsyncMeasureId);
    }

    public void deleteAsyncMeasure(Measure asyncMeasure) {
        this.deleteAsyncMeasureSnapshots(asyncMeasure.getId());
        this.getSession().remove(asyncMeasure);
    }

    public Snapshot getPreviousSnapshot(Date date) {
        try {
            return (Snapshot)this.getSession().createQuery("SELECT s FROM Snapshot s WHERE s.createdAt<:date AND s.scope=:scope ORDER BY s.createdAt DESC").setParameter("date", (Object)date).setParameter("scope", (Object)"PRJ").setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Snapshot> getNextSnapshotsUntilDate(Measure measure, Date date) {
        Query query = this.getSession().createQuery("SELECT s FROM Snapshot s WHERE s.resource.id=:projectId AND s.createdAt>=:beginDate " + (date != null ? "AND s.createdAt<:endDate " : "") + "AND s.scope=:scope " + "ORDER BY s.createdAt ASC ").setParameter("projectId", (Object)measure.getProjectId()).setParameter("beginDate", (Object)measure.getMeasureDate()).setParameter("scope", (Object)"PRJ");
        if (date != null) {
            query.setParameter("endDate", (Object)date);
        }
        return query.getResultList();
    }

    public AsyncMeasureSnapshot createAsyncMeasureSnapshot(Integer AsyncMeasureId, Integer snapshotId, Date AsyncMeasureDate, Date snapshotDate, Integer metricId, Integer projectId) {
        AsyncMeasureSnapshot AsyncMeasureSnapshot2 = new AsyncMeasureSnapshot(AsyncMeasureId, snapshotId, AsyncMeasureDate, snapshotDate, metricId, projectId);
        this.getSession().save((Object)AsyncMeasureSnapshot2);
        return AsyncMeasureSnapshot2;
    }

    public void updateAsyncMeasureSnapshot(AsyncMeasureSnapshot asyncMeasureSnapshot, Snapshot snapshot) {
        if (snapshot != null) {
            asyncMeasureSnapshot.setSnapshotId(snapshot.getId());
            asyncMeasureSnapshot.setSnapshotDate(snapshot.getCreatedAt());
        } else {
            asyncMeasureSnapshot.setSnapshotId(null);
            asyncMeasureSnapshot.setSnapshotDate(null);
        }
        this.getSession().merge(asyncMeasureSnapshot);
    }

    public void removeSnapshotFromAsyncMeasureSnapshot(AsyncMeasureSnapshot asyncMeasureSnapshot) {
        asyncMeasureSnapshot.setSnapshotId(null);
        asyncMeasureSnapshot.setSnapshotDate(null);
        this.getSession().merge(asyncMeasureSnapshot);
    }

    public AsyncMeasureSnapshot getNextAsyncMeasureSnapshot(Integer projetcId, Integer metricId, Date date) {
        try {
            return (AsyncMeasureSnapshot)this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.metricId=:metricId AND ams.measureDate>:date ORDER BY ams.measureDate ASC").setParameter("projectId", (Object)projetcId).setParameter("metricId", (Object)metricId).setParameter("date", (Object)date).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<AsyncMeasureSnapshot> getNextAsyncMeasureSnapshotsUntilDate(Measure asyncMeasure, Date endDate) {
        Query query = this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.metricId=:metricId " + (endDate != null ? "AND ams.measureDate<:endDate " : "") + "AND ams.snapshotDate>=:measureDate " + "ORDER BY ams.snapshotDate ASC ").setParameter("projectId", (Object)asyncMeasure.getProjectId()).setParameter("metricId", (Object)asyncMeasure.getMetric().getId()).setParameter("measureDate", (Object)asyncMeasure.getMeasureDate());
        if (endDate != null) {
            query.setParameter("endDate", (Object)endDate);
        }
        return query.getResultList();
    }

    public List<AsyncMeasureSnapshot> getPreviousAsyncMeasureSnapshots(Integer projectId, Date beginDate, Date endDate) {
        Query query = this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.measureDate<=:endDate " + (beginDate != null ? "AND ams.measureDate>:beginDate " : "") + "AND ams.snapshotId IS NULL " + "ORDER BY ams.measureDate ASC").setParameter("projectId", (Object)projectId).setParameter("endDate", (Object)endDate);
        if (beginDate != null) {
            query.setParameter("beginDate", (Object)beginDate);
        }
        return query.getResultList();
    }

    public List<AsyncMeasureSnapshot> getAsyncMeasureSnapshotsFromSnapshotId(Integer snapshotId, List<Integer> metricIdsToExclude) {
        Query query = this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.snapshotId=:snapshotId " + (!metricIdsToExclude.isEmpty() ? "AND ams.metricId NOT IN (:metricIdsToExclude) " : "") + "ORDER BY ams.measureDate ASC").setParameter("snapshotId", (Object)snapshotId);
        if (!metricIdsToExclude.isEmpty()) {
            query.setParameter("metricIdsToExclude", metricIdsToExclude);
        }
        return query.getResultList();
    }

    public AsyncMeasureSnapshot getLastAsyncMeasureSnapshot(Integer projetcId, Integer metricId, Date date) {
        try {
            return (AsyncMeasureSnapshot)this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.metricId=:metricId AND ams.measureDate<:date ORDER BY ams.measureDate DESC").setParameter("projectId", (Object)projetcId).setParameter("metricId", (Object)metricId).setParameter("date", (Object)date).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public void deleteAsyncMeasureSnapshots(Integer asyncMeasureId) {
        this.getSession().createQuery("DELETE FROM AsyncMeasureSnapshot ams WHERE ams.measureId=:measureId").setParameter("measureId", (Object)asyncMeasureId).executeUpdate();
    }
}

