/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.measures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.measures.AsyncMeasureSnapshot;
import org.sonar.commons.measures.AsyncMeasuresDao;
import org.sonar.commons.resources.Measure;
import org.sonar.commons.resources.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncMeasuresService {
    private DatabaseSession session;

    public AsyncMeasuresService(DatabaseSession session) {
        this.session = session;
    }

    public void refresh(Snapshot snapshot) {
        AsyncMeasuresDao dao = new AsyncMeasuresDao(this.session);
        Snapshot previousSnapshot = dao.getPreviousSnapshot(snapshot.getCreatedAt());
        Date datePreviousSnapshot = previousSnapshot != null ? previousSnapshot.getCreatedAt() : null;
        List<AsyncMeasureSnapshot> previousAsyncMeasureSnapshots = dao.getPreviousAsyncMeasureSnapshots(snapshot.getResource().getId(), datePreviousSnapshot, snapshot.getCreatedAt());
        if (previousSnapshot != null) {
            previousAsyncMeasureSnapshots.addAll(dao.getAsyncMeasureSnapshotsFromSnapshotId(previousSnapshot.getId(), this.getMetricIds(previousAsyncMeasureSnapshots)));
        }
        for (AsyncMeasureSnapshot asyncMeasureSnapshot : this.purge(previousAsyncMeasureSnapshots)) {
            if (asyncMeasureSnapshot.getSnapshotId() == null) {
                dao.updateAsyncMeasureSnapshot(asyncMeasureSnapshot, snapshot);
                continue;
            }
            dao.createAsyncMeasureSnapshot(asyncMeasureSnapshot.getMeasureId(), snapshot.getId(), asyncMeasureSnapshot.getMeasureDate(), snapshot.getCreatedAt(), asyncMeasureSnapshot.getMetricId(), asyncMeasureSnapshot.getProjectId());
        }
        this.session.commit();
    }

    public void registerMeasure(Integer id) {
        AsyncMeasuresDao dao = new AsyncMeasuresDao(this.session);
        this.registerMeasure(dao.getAsyncMeasure(id), dao);
    }

    protected void registerMeasure(Measure measure, AsyncMeasuresDao dao) {
        AsyncMeasureSnapshot nextAsyncMeasureSnapshot = dao.getNextAsyncMeasureSnapshot(measure.getProjectId(), measure.getMetric().getId(), measure.getMeasureDate());
        Date dateNextAsyncMeasure = nextAsyncMeasureSnapshot != null ? nextAsyncMeasureSnapshot.getMeasureDate() : null;
        List<AsyncMeasureSnapshot> nextAsyncMeasureSnapshots = dao.getNextAsyncMeasureSnapshotsUntilDate(measure, dateNextAsyncMeasure);
        if (!nextAsyncMeasureSnapshots.isEmpty()) {
            for (AsyncMeasureSnapshot asyncMeasureSnapshot : nextAsyncMeasureSnapshots) {
                dao.createAsyncMeasureSnapshot(measure.getId(), asyncMeasureSnapshot.getSnapshotId(), measure.getMeasureDate(), asyncMeasureSnapshot.getSnapshotDate(), measure.getMetric().getId(), measure.getProjectId());
                dao.removeSnapshotFromAsyncMeasureSnapshot(asyncMeasureSnapshot);
            }
        } else {
            List<Snapshot> nextSnapshotsUntilDate = dao.getNextSnapshotsUntilDate(measure, dateNextAsyncMeasure);
            if (!nextSnapshotsUntilDate.isEmpty()) {
                for (Snapshot nextSnapshot : nextSnapshotsUntilDate) {
                    dao.createAsyncMeasureSnapshot(measure.getId(), nextSnapshot.getId(), measure.getMeasureDate(), nextSnapshot.getCreatedAt(), measure.getMetric().getId(), measure.getProjectId());
                }
            } else {
                dao.createAsyncMeasureSnapshot(measure.getId(), null, measure.getMeasureDate(), null, measure.getMetric().getId(), measure.getProjectId());
            }
        }
    }

    private List<Integer> getMetricIds(List<AsyncMeasureSnapshot> list) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (AsyncMeasureSnapshot ams : list) {
            ids.add(ams.getMetricId());
        }
        return ids;
    }

    private Collection<AsyncMeasureSnapshot> purge(List<AsyncMeasureSnapshot> list) {
        LinkedHashMap<Integer, AsyncMeasureSnapshot> measuresById = new LinkedHashMap<Integer, AsyncMeasureSnapshot>();
        for (AsyncMeasureSnapshot currentAsyncMeasureSnapshot : list) {
            AsyncMeasureSnapshot asyncMeasureSnapshotFromMap = (AsyncMeasureSnapshot)measuresById.get(currentAsyncMeasureSnapshot.getMetricId());
            if (asyncMeasureSnapshotFromMap != null) {
                if (!asyncMeasureSnapshotFromMap.getMeasureDate().before(currentAsyncMeasureSnapshot.getMeasureDate())) continue;
                measuresById.put(currentAsyncMeasureSnapshot.getMetricId(), currentAsyncMeasureSnapshot);
                continue;
            }
            measuresById.put(currentAsyncMeasureSnapshot.getMetricId(), currentAsyncMeasureSnapshot);
        }
        return measuresById.values();
    }

    public void deleteMeasure(Integer id) {
        AsyncMeasuresDao dao = new AsyncMeasuresDao(this.session);
        Measure measure = dao.getAsyncMeasure(id);
        AsyncMeasureSnapshot pastAsyncMeasureSnapshot = dao.getLastAsyncMeasureSnapshot(measure.getProjectId(), measure.getMetric().getId(), measure.getMeasureDate());
        dao.deleteAsyncMeasure(measure);
        if (pastAsyncMeasureSnapshot != null) {
            Measure pastAsyncMeasure = dao.getAsyncMeasure(pastAsyncMeasureSnapshot.getMeasureId());
            dao.deleteAsyncMeasureSnapshots(pastAsyncMeasureSnapshot.getMeasureId());
            this.refresh(pastAsyncMeasure, dao);
        }
        this.session.commit();
    }

    protected void refresh(Measure measure, AsyncMeasuresDao dao) {
        AsyncMeasureSnapshot nextAsyncMeasureSnapshot = dao.getNextAsyncMeasureSnapshot(measure.getProjectId(), measure.getMetric().getId(), measure.getMeasureDate());
        Date dateNextAsyncMeasure = nextAsyncMeasureSnapshot != null ? nextAsyncMeasureSnapshot.getMeasureDate() : null;
        List<AsyncMeasureSnapshot> nextAsyncMeasureSnapshots = dao.getNextAsyncMeasureSnapshotsUntilDate(measure, dateNextAsyncMeasure);
        if (!nextAsyncMeasureSnapshots.isEmpty()) {
            for (AsyncMeasureSnapshot asyncMeasureSnapshot : nextAsyncMeasureSnapshots) {
                dao.createAsyncMeasureSnapshot(measure.getId(), asyncMeasureSnapshot.getSnapshotId(), measure.getMeasureDate(), asyncMeasureSnapshot.getSnapshotDate(), measure.getMetric().getId(), measure.getProjectId());
                dao.removeSnapshotFromAsyncMeasureSnapshot(asyncMeasureSnapshot);
            }
        } else {
            List<Snapshot> nextSnapshotsUntilDate = dao.getNextSnapshotsUntilDate(measure, dateNextAsyncMeasure);
            if (!nextSnapshotsUntilDate.isEmpty()) {
                for (Snapshot nextSnapshot : nextSnapshotsUntilDate) {
                    dao.createAsyncMeasureSnapshot(measure.getId(), nextSnapshot.getId(), measure.getMeasureDate(), nextSnapshot.getCreatedAt(), measure.getMetric().getId(), measure.getProjectId());
                }
            } else {
                dao.createAsyncMeasureSnapshot(measure.getId(), null, measure.getMeasureDate(), null, measure.getMetric().getId(), measure.getProjectId());
            }
        }
    }
}

