/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.profiles;

import java.util.List;
import org.sonar.commons.BaseDao;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.resources.Resource;
import org.sonar.commons.rules.RulesProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilesDao
extends BaseDao {
    public ProfilesDao(DatabaseSession session) {
        super(session);
    }

    public List<RulesProfile> getActiveProfiles() {
        return this.getSession().getResults(RulesProfile.class, "defaultProfile", true);
    }

    public RulesProfile getActiveProfile(String languageKey, String projectResourceKey) {
        Resource projectResource = this.getSession().getSingleResult(Resource.class, "key", projectResourceKey, "scope", "PRJ", "enabled", true);
        if (projectResource != null && projectResource.getRulesProfile() != null) {
            return projectResource.getRulesProfile();
        }
        return this.getSession().getSingleResult(RulesProfile.class, "defaultProfile", true, "language", languageKey);
    }

    public List<RulesProfile> getProfiles(String languageKey) {
        return this.getSession().getResults(RulesProfile.class, "language", languageKey);
    }

    public List<RulesProfile> getProfiles() {
        return this.getSession().getResults(RulesProfile.class);
    }

    public List<RulesProfile> getProvidedProfiles() {
        return this.getSession().getResults(RulesProfile.class, "provided", true);
    }

    public RulesProfile getProfile(String languageKey, String profileName) {
        return this.getSession().getSingleResult(RulesProfile.class, "language", languageKey, "name", profileName);
    }

    public RulesProfile getProfileById(int profileId) {
        return (RulesProfile)this.getSession().getEntityManager().getReference(RulesProfile.class, (Object)profileId);
    }
}

