/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.sonar.commons.Metric;
import org.sonar.commons.resources.MeasureData;
import org.sonar.commons.resources.MeasureKey;
import org.sonar.commons.rules.Rule;

@Entity
@Table(name="project_measures")
public class Measure {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="PROJECT_MEASURES_SEQ", sequenceName="PROJECT_MEASURES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="PROJECT_MEASURES_SEQ")
    private Integer id;
    @Column(name="value", updatable=true, nullable=true, precision=30, scale=20)
    private Double value = 0.0;
    @Column(name="text_value", updatable=true, nullable=true, length=96)
    private String textValue;
    @Column(name="tendency", updatable=true, nullable=true)
    private Integer tendency;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="metric_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private Metric metric;
    @Column(name="snapshot_id", updatable=true, nullable=true)
    private Integer snapshotId;
    @Column(name="project_id", updatable=true, nullable=true)
    private Integer projectId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="measure_date", updatable=true, nullable=true)
    private Date measureDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rule_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private Rule rule;
    @Column(name="rules_category_id")
    private Integer rulesCategoryId;
    @Column(name="alert_status", updatable=true, nullable=true, length=5)
    private String alertStatus;
    @Column(name="alert_text", updatable=true, nullable=true, length=4000)
    private String alertText;
    @OneToMany(mappedBy="measure", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    private List<MeasureData> measureData = new ArrayList<MeasureData>();

    public Measure(Metric metric, Double val) {
        if (val.isNaN() || val.isInfinite()) {
            throw new IllegalArgumentException("Measure value is NaN. Metric=" + metric);
        }
        this.metric = metric;
        this.value = val;
    }

    public Measure(Metric metric, Metric.Level level) {
        this.metric = metric;
        if (level != null) {
            this.textValue = level.toString();
        }
    }

    public Measure(Metric metric, String val) {
        this.metric = metric;
        if (metric.isDataType()) {
            this.measureData.add(new MeasureData(this, val));
        } else {
            this.textValue = val;
        }
    }

    public Measure(MeasureKey key, Double val) {
        if (val == Double.NaN) {
            throw new IllegalArgumentException("Measure value is NaN. Key=" + key);
        }
        this.rule = key.getRule();
        this.rulesCategoryId = key.getRulesCategoryId();
        this.metric = key.getMetric();
        this.value = val;
    }

    public Measure(MeasureKey key, Metric.Level level) {
        this.rule = key.getRule();
        this.rulesCategoryId = key.getRulesCategoryId();
        this.metric = key.getMetric();
        if (level != null) {
            this.textValue = level.toString();
        }
    }

    public Measure(MeasureKey key, String val) {
        this.rule = key.getRule();
        this.rulesCategoryId = key.getRulesCategoryId();
        this.metric = key.getMetric();
        if (key.getMetric().isDataType()) {
            this.measureData.add(new MeasureData(this, val));
        } else {
            this.textValue = val;
        }
    }

    public Measure() {
    }

    public Double getValue() {
        return this.value;
    }

    public Measure setValue(Double value) throws IllegalArgumentException {
        if (value != null && (value.isNaN() || value.isInfinite())) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        return this;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public Metric.Level getLevelValue() {
        if (this.textValue != null) {
            return Metric.Level.valueOf(this.textValue);
        }
        return null;
    }

    public Measure setTextValue(String textValue) {
        this.textValue = textValue;
        return this;
    }

    public Integer getTendency() {
        return this.tendency;
    }

    public Measure setTendency(Integer tendency) {
        this.tendency = tendency;
        return this;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public Measure setSnapshotId(Integer snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Measure setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public Integer getRulesCategoryId() {
        return this.rulesCategoryId;
    }

    public Measure setRulesCategoryId(Integer id) {
        this.rulesCategoryId = id;
        return this;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Date getMeasureDate() {
        return this.measureDate;
    }

    public Measure setMeasureDate(Date measureDate) {
        this.measureDate = measureDate;
        return this;
    }

    public Metric.Level getAlertStatus() {
        if (this.alertStatus == null) {
            return null;
        }
        return Metric.Level.valueOf(this.alertStatus);
    }

    public Measure setAlertStatus(Metric.Level level) {
        this.alertStatus = level != null ? level.toString() : null;
        return this;
    }

    public String getData() {
        if (this.metric.isDataType() && this.measureData != null && !this.measureData.isEmpty()) {
            return this.measureData.get(0).getText();
        }
        return null;
    }

    public void setData(String data) {
        this.measureData.clear();
        this.measureData.add(new MeasureData(this, data));
    }

    public MeasureData getMeasureData() {
        if (this.measureData != null && !this.measureData.isEmpty()) {
            return this.measureData.get(0);
        }
        return null;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("value", (Object)this.value).append("metric", (Object)this.metric).toString();
    }

    public Integer getRuleId() {
        if (this.getRule() != null) {
            return this.getRule().getId();
        }
        return null;
    }

    public void copyFrom(Measure measure) {
        this.setAlertStatus(measure.getAlertStatus());
        this.setAlertText(measure.getAlertText());
        this.setMeasureDate(measure.getMeasureDate());
        this.setMetric(measure.getMetric());
        this.setProjectId(measure.getProjectId());
        this.setRule(measure.getRule());
        this.setRulesCategoryId(measure.getRulesCategoryId());
        this.setSnapshotId(measure.getSnapshotId());
        this.setTendency(measure.getTendency());
        this.setTextValue(measure.getTextValue());
        this.setValue(measure.getValue());
    }

    public void setMeasureData(MeasureData data) {
        if (this.measureData == null) {
            this.measureData = new ArrayList<MeasureData>();
        } else if (!this.measureData.isEmpty()) {
            this.measureData.clear();
        }
        this.measureData.add(data);
    }
}

