/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.sonar.commons.resources.Measure;

@Entity
@Table(name="measure_data")
public class MeasureData {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="MEASURE_DATA_SEQ", sequenceName="MEASURE_DATA_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="MEASURE_DATA_SEQ")
    private Integer id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="measure_id")
    private Measure measure;
    @Column(name="snapshot_id", updatable=true, nullable=true)
    private Integer snapshotId;
    @Column(name="data", updatable=true, nullable=true, length=0x9FFFFF6)
    private byte[] data;

    public MeasureData(Measure measure) {
        this.measure = measure;
    }

    public MeasureData(Measure measure, byte[] data) {
        this.measure = measure;
        this.data = data;
    }

    public MeasureData(Measure measure, String dataString) {
        this.measure = measure;
        this.data = dataString.getBytes();
    }

    public MeasureData() {
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getText() {
        if (this.data != null) {
            return new String(this.data);
        }
        return null;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Integer snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

