/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.commons.Metric;
import org.sonar.commons.resources.Measure;
import org.sonar.commons.rules.Rule;

public class MeasureKey
implements Cloneable {
    protected Metric metric;
    protected Integer rulesCategoryId;
    protected Rule rule;

    public MeasureKey(Metric metric, Integer categoryId) {
        this.metric = metric;
        this.rulesCategoryId = categoryId;
        this.rule = null;
    }

    public MeasureKey(Metric metric, Rule rule) {
        this.metric = metric;
        if (rule != null && rule.getRulesCategory() != null) {
            this.rulesCategoryId = rule.getRulesCategory().getId();
        }
        this.rule = rule;
    }

    public MeasureKey(Metric metric) {
        this.metric = metric;
        this.rulesCategoryId = null;
        this.rule = null;
    }

    public MeasureKey(Measure measure) {
        this(measure.getMetric(), measure.getRule());
    }

    public MeasureKey(Metric metric, Integer rulesCategoryId, Rule rule) {
        this.metric = metric;
        this.rulesCategoryId = rulesCategoryId;
        this.rule = rule;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MeasureKey)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MeasureKey other = (MeasureKey)obj;
        return new EqualsBuilder().append((Object)this.metric, (Object)other.metric).append((Object)this.rulesCategoryId, (Object)other.rulesCategoryId).append((Object)this.rule, (Object)other.rule).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.metric).append((Object)this.rulesCategoryId).append((Object)this.rule).toHashCode();
    }

    public Object clone() {
        return new MeasureKey(this.metric, this.rulesCategoryId, this.rule);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public MeasureKey setMetric(Metric metric) {
        this.metric = metric;
        return this;
    }

    public Integer getRulesCategoryId() {
        return this.rulesCategoryId;
    }

    public MeasureKey setRulesCategoryId(Integer id) {
        this.rulesCategoryId = id;
        return this;
    }

    public Rule getRule() {
        return this.rule;
    }

    public MeasureKey setRule(Rule rule) {
        this.rule = rule;
        return this;
    }
}

