/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.sonar.commons.BaseDao;
import org.sonar.commons.Metric;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.resources.Measure;
import org.sonar.commons.resources.Resource;
import org.sonar.commons.resources.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasuresDao
extends BaseDao {
    private Map<String, Metric> metricsByName = new HashMap<String, Metric>();

    public MeasuresDao(DatabaseSession session) {
        super(session);
    }

    public Metric getMetric(Metric metric) {
        return this.getMetricsByName().get(metric.getKey());
    }

    public Metric getMetric(String metricName) {
        return this.getMetricsByName().get(metricName);
    }

    public Collection<Metric> getMetrics() {
        return this.getMetricsByName().values();
    }

    public Collection<Metric> getEnabledMetrics() {
        return CollectionUtils.select(this.getMetricsByName().values(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return ((Metric)o).getEnabled();
            }
        });
    }

    public Collection<Metric> getUserDefinedMetrics() {
        return CollectionUtils.select(this.getMetricsByName().values(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                Metric m = (Metric)o;
                return m.getEnabled() != false && m.getOrigin() != Metric.Origin.JAV;
            }
        });
    }

    public void disableAutomaticMetrics() {
        this.getSession().createQuery("update " + Metric.class.getSimpleName() + " m set m.enabled=false where m.userManaged=false").executeUpdate();
        this.getSession().commit();
        this.metricsByName.clear();
    }

    public void registerMetrics(Collection<Metric> metrics) {
        if (metrics != null) {
            for (Metric metric : metrics) {
                metric.setEnabled(Boolean.TRUE);
                this.persistMetric(metric);
                this.getSession().commit();
            }
        }
    }

    public void persistMetric(Metric metric) {
        Metric dbMetric = this.getMetric(metric);
        if (dbMetric != null) {
            dbMetric.setDescription(metric.getDescription());
            dbMetric.setDirection(metric.getDirection());
            dbMetric.setDomain(metric.getDomain());
            dbMetric.setEnabled(metric.getEnabled());
            dbMetric.setQualitative(metric.getQualitative());
            dbMetric.setName(metric.getName());
            dbMetric.setType(metric.getType());
            dbMetric.setUserManaged(metric.getUserManaged());
            dbMetric.setOrigin(metric.getOrigin());
            this.getSession().getEntityManager().merge((Object)dbMetric);
        } else {
            this.getSession().getEntityManager().persist((Object)metric);
        }
        this.metricsByName.clear();
    }

    public void disabledMetrics(Collection<Metric> metrics) {
        for (Metric metric : metrics) {
            metric.setEnabled(Boolean.FALSE);
            this.getSession().getEntityManager().persist((Object)metric);
            this.metricsByName.put(metric.getName(), metric);
        }
    }

    private Map<String, Metric> getMetricsByName() {
        if (this.metricsByName.isEmpty()) {
            List<Metric> metrics = this.getSession().getResults(Metric.class);
            for (Metric metric : metrics) {
                this.metricsByName.put(metric.getKey(), metric);
            }
        }
        return this.metricsByName;
    }

    public List<Measure> getMeasures(Integer snapshotId) {
        return this.getSession().getResults(Measure.class, "snapshotId", snapshotId);
    }

    public Snapshot getSnapshot(int snapshotId) {
        return this.getSession().getEntity(Snapshot.class, snapshotId);
    }

    public String getSnapshotProjectName(int snapshotId) {
        Query query = this.getSession().createQuery("SELECT p.name FROM " + Resource.class.getSimpleName() + " p, Snapshot s WHERE s.resource=p AND s.id=:id");
        query.setParameter("id", (Object)snapshotId);
        return (String)query.getSingleResult();
    }

    public List<Snapshot> getChildSnapshots(Snapshot snapshot) {
        return this.getSession().getResults(Snapshot.class, "parent", snapshot);
    }
}

