/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.sonar.commons.resources.Resource;

@Entity(name="ProjectLink")
@Table(name="project_links")
public class ProjectLink
implements Serializable {
    public static final int NAME_COLUMN_SIZE = 128;
    public static final int HREF_COLUMN_SIZE = 2048;
    public static final String LINK_HOME_PAGE = "homepage";
    public static final String LINK_CONTINUOUS_INTEGRATION = "ci";
    public static final String LINK_ISSUES_TRACKER = "issue";
    public static final String LINK_SCM_URL = "scm";
    public static final String LINK_SCM_RO_CONNECTION = "scm_ro";
    public static final String LINK_SCM_DEV_CONNECTION = "scm_dev";
    private static final long serialVersionUID = 3473761819014871039L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="PROJECT_LINKS_SEQ", sequenceName="PROJECT_LINKS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="PROJECT_LINKS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id", updatable=false, nullable=false)
    private Resource resource;
    @Column(name="link_type", updatable=true, nullable=true, length=20)
    private String type;
    @Column(name="name", updatable=true, nullable=true, length=128)
    private String name;
    @Column(name="href", updatable=true, nullable=false, length=2048)
    private String href;

    public ProjectLink() {
    }

    public ProjectLink(String type, String name, String href) {
        this.type = type;
        this.setName(name);
        this.setHref(href);
    }

    public ProjectLink(Resource resource, String type, String name, String href) {
        this.resource = resource;
        this.type = type;
        this.name = name;
        this.href = href;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.abbreviate((String)name, (int)128);
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = StringUtils.abbreviate((String)href, (int)2048);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

