/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.BatchSize;
import org.sonar.commons.resources.ProjectLink;
import org.sonar.commons.rules.RulesProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="projects")
public class Resource
implements Serializable,
Cloneable {
    public static final String SCOPE_PROJECT = "PRJ";
    public static final String SCOPE_DIRECTORY = "DIR";
    public static final String SCOPE_FILE = "FIL";
    public static final String QUALIFIER_PROJECT_TRUNK = "TRK";
    public static final String QUALIFIER_PROJECT_BRANCH = "BRC";
    public static final String QUALIFIER_PACKAGE = "PAC";
    public static final String QUALIFIER_DIRECTORY = "DIR";
    public static final String QUALIFIER_FILE = "FIL";
    public static final String QUALIFIER_CLASS = "CLA";
    public static final String QUALIFIER_UNIT_TEST = "UTS";
    private static final long serialVersionUID = -7747333646654989328L;
    public static final int DESCRIPTION_COLUMN_SIZE = 2000;
    public static final int NAME_COLUMN_SIZE = 256;
    public static final int KEY_SIZE = 230;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="PROJECTS_SEQ", sequenceName="PROJECTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="PROJECTS_SEQ")
    private Integer id;
    @Column(name="name", updatable=true, nullable=true, length=256)
    private String name;
    @Column(name="description", updatable=true, nullable=true, length=2000)
    private String description;
    @Column(name="enabled", updatable=true, nullable=false)
    private Boolean enabled = Boolean.TRUE;
    @Column(name="scope", updatable=true, nullable=false, length=3)
    private String scope;
    @Column(name="qualifier", updatable=true, nullable=false, length=3)
    private String qualifier;
    @Column(name="kee", updatable=false, nullable=false, length=230)
    private String key;
    @Column(name="language", updatable=true, nullable=true, length=5)
    private String languageKey;
    @Column(name="root_id", updatable=true, nullable=true)
    private Integer rootId;
    @OneToMany(mappedBy="resource", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=8)
    private List<ProjectLink> projectLinks = new ArrayList<ProjectLink>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="profile_id", updatable=true, nullable=true)
    private RulesProfile rulesProfile;

    public Resource() {
    }

    public Resource(String scope, String key, String qualifier, Integer rootId, String name) {
        this.scope = scope;
        this.key = key;
        this.rootId = rootId;
        this.name = name;
        this.qualifier = qualifier;
    }

    public List<ProjectLink> getProjectLinks() {
        return this.projectLinks;
    }

    public void setProjectLinks(List<ProjectLink> projectLinks) {
        this.projectLinks = projectLinks;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.abbreviate((String)description, (int)2000);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.abbreviate((String)name, (int)256);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getKey() {
        return this.key;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public void setLanguageKey(String lang) {
        this.languageKey = lang;
    }

    public void setKey(String key) {
        if (key.length() > 230) {
            throw new IllegalArgumentException("Resource key is too long, max is 230 characters. Got : " + key);
        }
        this.key = key;
    }

    public Integer getRootId() {
        return this.rootId;
    }

    public void setRootId(Integer rootId) {
        this.rootId = rootId;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    public void setRulesProfile(RulesProfile rulesProfile) {
        this.rulesProfile = rulesProfile;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public ProjectLink getProjectLinkByType(String type) {
        if (type == null) {
            return null;
        }
        for (ProjectLink projectLink : this.projectLinks) {
            if (!type.equals(projectLink.getType())) continue;
            return projectLink;
        }
        return null;
    }

    public boolean isProject() {
        return SCOPE_PROJECT.equals(this.scope);
    }

    public boolean isTrunkProject() {
        return this.isProject() && QUALIFIER_PROJECT_TRUNK.equals(this.qualifier);
    }

    public boolean isBranchProject() {
        return this.isProject() && QUALIFIER_PROJECT_BRANCH.equals(this.qualifier);
    }

    public boolean isDirectory() {
        return "DIR".equals(this.scope);
    }

    public boolean isFile() {
        return "FIL".equals(this.scope);
    }

    public boolean isPackage() {
        return QUALIFIER_PACKAGE.equals(this.qualifier);
    }

    public boolean isClass() {
        return QUALIFIER_CLASS.equals(this.qualifier);
    }

    public boolean isUnitTest() {
        return QUALIFIER_UNIT_TEST.equals(this.qualifier);
    }

    public static Resource newDirectory(String key, String qualifier, String language) {
        Resource dir = new Resource();
        dir.setKey(key);
        dir.setName(key);
        dir.setLanguageKey(language);
        dir.setQualifier(qualifier);
        dir.setScope("DIR");
        return dir;
    }

    public static Resource newFile(String key, String qualifier, String language) {
        Resource file = new Resource();
        file.setKey(key);
        file.setName(key);
        file.setLanguageKey(language);
        file.setQualifier(qualifier);
        file.setScope("FIL");
        return file;
    }

    public static Resource newProject(String key, String language, boolean isTrunk) {
        Resource project = new Resource();
        project.setKey(key);
        project.setLanguageKey(language);
        project.setQualifier(isTrunk ? QUALIFIER_PROJECT_TRUNK : QUALIFIER_PROJECT_BRANCH);
        project.setScope(SCOPE_PROJECT);
        return project;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Resource)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Resource other = (Resource)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.enabled, (Object)other.enabled).append((Object)this.rootId, (Object)other.rootId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.key).append((Object)this.enabled).append((Object)this.rootId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("key", (Object)this.key).append("scope", (Object)this.scope).append("qualifier", (Object)this.qualifier).append("name", (Object)this.name).append("lang", (Object)this.languageKey).append("enabled", (Object)this.enabled).append("rootId", (Object)this.rootId).toString();
    }

    public Object clone() {
        Resource clone = new Resource(this.getScope(), this.getKey(), this.getQualifier(), this.getRootId(), this.getName());
        clone.setDescription(this.getDescription());
        clone.setEnabled(this.getEnabled());
        clone.setProjectLinks(this.getProjectLinks());
        clone.setRulesProfile(this.getRulesProfile());
        clone.setLanguageKey(this.getLanguageKey());
        return clone;
    }
}

