/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.resources;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.sonar.commons.resources.Resource;

@Entity
@Table(name="snapshots")
public class Snapshot
implements Serializable {
    private static final long serialVersionUID = -6637859483638004953L;
    public static final String STATUS_UNPROCESSED = "U";
    public static final String STATUS_PROCESSED = "P";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="SNAPSHOTS_SEQ", sequenceName="SNAPSHOTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SNAPSHOTS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id", updatable=true, nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Resource resource;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=true, nullable=true)
    private Date createdAt;
    @Column(name="version", updatable=true, nullable=true, length=32)
    private String version;
    @Column(name="islast")
    private Boolean last = Boolean.FALSE;
    @Column(name="status")
    private String status = "U";
    @Column(name="purged")
    private Boolean purged = Boolean.FALSE;
    @Column(name="scope", updatable=true, nullable=true, length=3)
    private String scope;
    @Column(name="path", updatable=true, nullable=true, length=96)
    private String path;
    @Column(name="depth", updatable=true, nullable=true)
    private Integer depth;
    @Column(name="qualifier", updatable=true, nullable=true, length=3)
    private String qualifier;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="root_snapshot_id", updatable=true, nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Snapshot root;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="parent_snapshot_id", updatable=true, nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Snapshot parent;

    public Snapshot() {
    }

    public Snapshot(Resource resource, boolean last, String status, Date date) {
        this();
        this.setResource(resource);
        this.status = status;
        this.last = last;
        this.createdAt = date;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.scope = resource.getScope();
        this.qualifier = resource.getQualifier();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Snapshot getParent() {
        return this.parent;
    }

    public void setParent(Snapshot parent) {
        this.parent = parent;
    }

    public Boolean getLast() {
        return this.last;
    }

    public void setLast(Boolean last) {
        this.last = last;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getPurged() {
        return this.purged;
    }

    public void setPurged(Boolean purged) {
        this.purged = purged;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public Snapshot getRoot() {
        return this.root;
    }

    public void setRoot(Snapshot root) {
        this.root = root;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        if (depth != null && depth < 0) {
            throw new IllegalArgumentException("depth can not be negative : " + depth);
        }
        this.depth = depth;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Snapshot other = (Snapshot)obj;
        return new EqualsBuilder().append((Object)this.resource, (Object)other.getResource()).append((Object)this.createdAt, (Object)other.getCreatedAt()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.resource).append((Object)this.createdAt).toHashCode();
    }
}

