/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.commons.rules.ActiveRuleParam;
import org.sonar.commons.rules.Rule;
import org.sonar.commons.rules.RuleFailureLevel;
import org.sonar.commons.rules.RulesProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="active_rules")
public class ActiveRule
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6161808961786732538L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="ACTIVE_RULES_SEQ", sequenceName="ACTIVE_RULES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="ACTIVE_RULES_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rule_id", updatable=true, nullable=false)
    private Rule rule;
    @Column(name="failure_level", updatable=true, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private RuleFailureLevel level;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="profile_id", updatable=true, nullable=false)
    private RulesProfile rulesProfile;
    @OneToMany(mappedBy="activeRule", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ActiveRuleParam> activeRuleParams = new ArrayList<ActiveRuleParam>();

    public ActiveRule() {
    }

    public ActiveRule(RulesProfile profile, Rule rule, RuleFailureLevel level) {
        this.rule = rule;
        this.level = level;
        this.rulesProfile = profile;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public RuleFailureLevel getLevel() {
        return this.level;
    }

    public void setLevel(RuleFailureLevel level) {
        this.level = level;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    public void setRulesProfile(RulesProfile rulesProfile) {
        this.rulesProfile = rulesProfile;
    }

    public List<ActiveRuleParam> getActiveRuleParams() {
        return this.activeRuleParams;
    }

    public void setActiveRuleParams(List<ActiveRuleParam> params) {
        this.activeRuleParams = params;
    }

    public String getPluginName() {
        return this.rule.getPluginName();
    }

    public String getConfigKey() {
        return this.rule.getConfigKey();
    }

    public String getRuleKey() {
        return this.rule.getKey();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActiveRule)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ActiveRule other = (ActiveRule)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("rule", (Object)this.rule).append("level", (Object)this.level).append("params", this.activeRuleParams).toString();
    }

    public Object clone() {
        ActiveRule clone = new ActiveRule(this.getRulesProfile(), this.getRule(), this.getLevel());
        if (CollectionUtils.isNotEmpty(this.getActiveRuleParams())) {
            clone.setActiveRuleParams(new ArrayList<ActiveRuleParam>(CollectionUtils.collect(this.getActiveRuleParams(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((ActiveRuleParam)input).clone();
                }
            })));
        }
        return clone;
    }
}

