/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.sonar.commons.rules.RuleParam;
import org.sonar.commons.rules.RulesCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Entity
@Table(name="rules")
public class Rule {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULES_SEQ", sequenceName="RULES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULES_SEQ")
    private Integer id;
    @Column(name="name", updatable=true, nullable=false)
    private String name;
    @Column(name="plugin_rule_key", updatable=false, nullable=true)
    private String key;
    @Column(name="plugin_config_key", updatable=true, nullable=true)
    private String configKey;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rules_category_id", updatable=true, nullable=true)
    private RulesCategory rulesCategory;
    @Column(name="description", updatable=true, nullable=true, length=0xFFFFFF)
    private String description;
    @Column(name="plugin_name", updatable=true, nullable=true)
    private String pluginName;
    @OneToMany(mappedBy="rule", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<RuleParam> params = new ArrayList<RuleParam>();

    public Rule() {
    }

    public Rule(String name, String key, RulesCategory rulesCategory, String pluginName, String description) {
        this();
        this.setName(name);
        this.key = key;
        this.rulesCategory = rulesCategory;
        this.pluginName = pluginName;
        this.description = description;
    }

    public Rule(String name, String key, String configKey, RulesCategory rulesCategory, String pluginName, String description) {
        this();
        this.setName(name);
        this.key = key;
        this.configKey = configKey;
        this.rulesCategory = rulesCategory;
        this.pluginName = pluginName;
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.removeNewLineCharacters(name);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public RulesCategory getRulesCategory() {
        return this.rulesCategory;
    }

    public void setRulesCategory(RulesCategory rulesCategory) {
        this.rulesCategory = rulesCategory;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.strip((String)description);
    }

    public List<RuleParam> getParams() {
        return this.params;
    }

    public void setParams(List<RuleParam> params) {
        this.params = params;
    }

    public Integer getCategoryId() {
        if (this.rulesCategory != null) {
            return this.rulesCategory.getId();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rule)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Rule other = (Rule)obj;
        return new EqualsBuilder().append((Object)this.pluginName, (Object)other.getPluginName()).append((Object)this.key, (Object)other.getKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.pluginName).append((Object)this.key).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("key", (Object)this.key).append("configKey", (Object)this.configKey).append("categ", (Object)this.rulesCategory).append("plugin", (Object)this.pluginName).append("params", this.params).toString();
    }

    protected String removeNewLineCharacters(String text) {
        text = StringUtils.remove((String)text, (String)"\n");
        text = StringUtils.remove((String)text, (String)"\r");
        text = StringUtils.remove((String)text, (String)"\n\r");
        text = StringUtils.remove((String)text, (String)"\r\n");
        return text;
    }
}

