/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.commons.resources.Snapshot;
import org.sonar.commons.rules.Rule;
import org.sonar.commons.rules.RuleFailureLevel;
import org.sonar.commons.rules.RuleFailureParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="rule_failures")
public class RuleFailure
implements Serializable {
    private static final long serialVersionUID = 6573631005994829171L;
    public static final int MESSAGE_COLUMN_SIZE = 500;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULE_FAILURES_SEQ", sequenceName="RULE_FAILURES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULE_FAILURES_SEQ")
    private Integer id;
    @Column(name="snapshot_id")
    protected Integer snapshotId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rule_id")
    private Rule rule;
    @OneToMany(mappedBy="ruleFailure", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    private List<RuleFailureParam> params;
    @Column(name="failure_level", updatable=false, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private RuleFailureLevel failureLevel;
    @Column(name="message", updatable=false, nullable=true, length=500)
    private String message;

    public RuleFailure() {
    }

    public RuleFailure(Rule rule, RuleFailureLevel level) {
        this.rule = rule;
        this.failureLevel = level;
        this.params = new ArrayList<RuleFailureParam>();
    }

    public RuleFailure(Rule rule, RuleFailureLevel level, Snapshot snapshot) {
        this.rule = rule;
        this.failureLevel = level;
        this.params = new ArrayList<RuleFailureParam>();
        this.snapshotId = snapshot.getId();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String mes = StringUtils.trim((String)message);
        this.message = StringUtils.abbreviate((String)mes, (int)499);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshotId = snapshot.getId();
        for (RuleFailureParam param : this.params) {
            param.setSnapshot(snapshot);
        }
    }

    public RuleFailureLevel getLevel() {
        return this.failureLevel;
    }

    public void setLevel(RuleFailureLevel level) {
        this.failureLevel = level;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public List<RuleFailureParam> getParameters() {
        return this.params;
    }

    public void setParameters(List<RuleFailureParam> ruleFailureParams) {
        this.params = ruleFailureParams;
    }

    public RuleFailureParam addParameter(String key, Double value) {
        return this.addParameter(key, value, null);
    }

    public RuleFailureParam addParameter(String key, Double value, Double value2) {
        if (this.params == null) {
            this.params = new ArrayList<RuleFailureParam>();
        }
        RuleFailureParam param = new RuleFailureParam(key, value, value2);
        param.setRuleFailure(this);
        this.params.add(param);
        return param;
    }

    public RuleFailureParam getParameter(String key) {
        for (RuleFailureParam param : this.params) {
            if (param == null || !param.getKey().equals(key)) continue;
            return param;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleFailure)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleFailure other = (RuleFailure)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

