/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.sonar.commons.resources.Snapshot;
import org.sonar.commons.rules.RuleFailure;

@Entity
@Table(name="rule_failure_params")
public class RuleFailureParam {
    public static final int PARAM_KEY_COLUMN_SIZE = 100;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULE_FAILURE_PARAMS_SEQ", sequenceName="RULE_FAILURE_PARAMS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULE_FAILURE_PARAMS_SEQ")
    private Integer id;
    @Column(name="param_key", updatable=false, nullable=false, length=100)
    private String key;
    @Column(name="value", updatable=false, nullable=true, precision=30, scale=20)
    private Double value;
    @Column(name="value2", updatable=false, nullable=true, precision=30, scale=20)
    private Double value2;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rule_failure_id")
    private RuleFailure ruleFailure;
    @Column(name="snapshot_id")
    protected Integer snapshotId;

    public RuleFailureParam(String key, Double value, Double value2) {
        this.setKey(key);
        this.value = value;
        this.value2 = value2;
    }

    public RuleFailureParam() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshotId = snapshot.getId();
    }

    public RuleFailure getRuleFailure() {
        return this.ruleFailure;
    }

    public void setRuleFailure(RuleFailure ruleFailure) {
        this.ruleFailure = ruleFailure;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (key.length() > 100) {
            throw new IllegalArgumentException("RuleFailureParam key " + key + " size too long :" + key.length());
        }
        this.key = key;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getValue2() {
        return this.value2;
    }

    public void setValue2(Double value2) {
        this.value2 = value2;
    }
}

