/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.commons.rules.Rule;

@Entity
@Table(name="rules_parameters")
public class RuleParam {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULES_PARAMETERS_SEQ", sequenceName="RULES_PARAMETERS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULES_PARAMETERS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rule_id")
    private Rule rule;
    @Column(name="name", updatable=true, nullable=false, length=128)
    private String key;
    @Column(name="description", updatable=true, nullable=false, length=4000)
    private String description;
    @Column(name="param_type", updatable=true, nullable=false, length=512)
    private String type;

    public RuleParam() {
    }

    public RuleParam(Rule rule, String key, String description, String type) {
        this.rule = rule;
        this.key = key;
        this.description = description;
        this.type = type;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.defaultString((String)description, (String)"");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleParam)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleParam other = (RuleParam)obj;
        return new EqualsBuilder().append((Object)this.rule, (Object)other.getRule()).append((Object)this.key, (Object)other.getKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.rule).append((Object)this.key).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("key", (Object)this.key).append("desc", (Object)this.description).append("type", (Object)this.type).toString();
    }
}

