/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.commons.BaseDao;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.resources.Snapshot;
import org.sonar.commons.rules.ActiveRule;
import org.sonar.commons.rules.ActiveRuleParam;
import org.sonar.commons.rules.Rule;
import org.sonar.commons.rules.RuleFailure;
import org.sonar.commons.rules.RuleParam;
import org.sonar.commons.rules.RulesCategory;
import org.sonar.commons.rules.RulesProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesDao
extends BaseDao {
    private List<RulesCategory> rulesCategories;

    public RulesDao(DatabaseSession session) {
        super(session);
    }

    public List<Rule> getRules() {
        return this.getSession().getResults(Rule.class);
    }

    public List<Rule> getRulesByPlugin(String pluginKey) {
        return this.getSession().getResults(Rule.class, "pluginName", pluginKey);
    }

    public List<Rule> getRulesByCategory(RulesCategory categ) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : this.getRules()) {
            if (!rule.getRulesCategory().equals(categ)) continue;
            result.add(rule);
        }
        return result;
    }

    public Rule getRuleByKey(String pluginKey, String ruleKey) {
        return this.getSession().getSingleResult(Rule.class, "key", ruleKey, "pluginName", pluginKey);
    }

    public Long countRules(List<String> plugins, String categoryName) {
        return (Long)this.getSession().createQuery("SELECT COUNT(r) FROM Rule r WHERE r.pluginName IN (:pluginNames) AND r.rulesCategory=:rulesCategory").setParameter("pluginNames", plugins).setParameter("rulesCategory", (Object)this.getCategory(categoryName)).getSingleResult();
    }

    public List<RulesCategory> getCategories() {
        if (this.rulesCategories == null) {
            this.rulesCategories = this.getSession().getResults(RulesCategory.class);
        }
        return this.rulesCategories;
    }

    public RulesCategory getCategory(String key) {
        return this.getSession().getSingleResult(RulesCategory.class, "name", key);
    }

    public List<RuleParam> getRuleParams() {
        return this.getSession().getResults(RuleParam.class);
    }

    public RuleParam getRuleParam(Rule rule, String paramKey) {
        return this.getSession().getSingleResult(RuleParam.class, "rule", rule, "key", paramKey);
    }

    public void addActiveRulesToProfile(List<ActiveRule> activeRules, int profileId, String pluginKey) {
        RulesProfile rulesProfile = this.getProfileById(profileId);
        for (ActiveRule activeRule : activeRules) {
            this.synchronizeRuleOfActiveRule(activeRule, pluginKey);
            activeRule.setRulesProfile(rulesProfile);
            this.getSession().save((Object)activeRule);
        }
    }

    public void deleteActiveRuleParameters(RuleParam ruleParam) {
        this.getSession().createQuery("DELETE FROM ActiveRuleParam arp WHERE ruleParam=:param").setParameter("param", (Object)ruleParam).executeUpdate();
    }

    public List<RuleFailure> getRuleFailures(Snapshot snapshot) {
        return this.getSession().getResults(RuleFailure.class, "snapshotId", snapshot.getId());
    }

    public void synchronizeRuleOfActiveRule(ActiveRule activeRule, String pluginKey) {
        Rule rule = activeRule.getRule();
        Rule ruleFromDataBase = this.getRuleByKey(pluginKey, rule.getKey());
        activeRule.setRule(ruleFromDataBase);
        List<RuleParam> ruleParamsFromDataBase = this.getRuleParams();
        for (ActiveRuleParam activeRuleParam : activeRule.getActiveRuleParams()) {
            boolean found = false;
            Iterator<RuleParam> iterator = ruleParamsFromDataBase.iterator();
            while (iterator.hasNext() && !found) {
                RuleParam ruleParamFromDataBase = iterator.next();
                if (!this.isRuleParamEqual(activeRuleParam.getRuleParam(), ruleParamFromDataBase, rule.getKey(), pluginKey)) continue;
                activeRuleParam.setRuleParam(ruleParamFromDataBase);
                found = true;
            }
        }
    }

    public boolean isRuleParamEqual(RuleParam ruleParam, RuleParam ruleParamFromDatabase, String ruleKey, String pluginKey) {
        return ruleParam.getKey().equals(ruleParamFromDatabase.getKey()) && ruleKey.equals(ruleParamFromDatabase.getRule().getKey()) && ruleParamFromDatabase.getRule().getPluginName().equals(pluginKey);
    }

    public RulesProfile getProfileById(int profileId) {
        return (RulesProfile)this.getSession().getEntityManager().getReference(RulesProfile.class, (Object)profileId);
    }
}

