/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.commons.alerts.Alert;
import org.sonar.commons.resources.Resource;
import org.sonar.commons.rules.ActiveRule;
import org.sonar.commons.rules.RuleFailureLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="rules_profiles")
public class RulesProfile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4024876470769619760L;
    public static final String SONAR_WAY_NAME = "Sonar way";
    public static final String SUN_CONVENTIONS_NAME = "Sun checks";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULES_PROFILES_SEQ", sequenceName="RULES_PROFILES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULES_PROFILES_SEQ")
    private Integer id;
    @Column(name="name", updatable=true, nullable=false)
    private String name;
    @Column(name="default_profile", updatable=true, nullable=false)
    private Boolean defaultProfile = Boolean.FALSE;
    @Column(name="provided", updatable=true, nullable=false)
    private Boolean provided = Boolean.FALSE;
    @Column(name="language", updatable=true, nullable=false)
    private String language;
    @OneToMany(mappedBy="rulesProfile", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ActiveRule> activeRules;
    @OneToMany(mappedBy="rulesProfile", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<Alert> alerts;
    @OneToMany(mappedBy="rulesProfile", fetch=FetchType.LAZY)
    private List<Resource> projects;

    public RulesProfile() {
    }

    public RulesProfile(String name) {
        this.name = name;
        this.activeRules = new ArrayList<ActiveRule>();
        this.alerts = new ArrayList<Alert>();
        this.projects = new ArrayList<Resource>();
    }

    public RulesProfile(String name, String language, boolean defaultProfile, boolean provided) {
        this(name);
        this.language = language;
        this.defaultProfile = defaultProfile;
        this.provided = provided;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ActiveRule> getActiveRules() {
        return this.activeRules;
    }

    public void setActiveRules(List<ActiveRule> activeRules) {
        this.activeRules = activeRules;
    }

    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Boolean getProvided() {
        return this.provided;
    }

    public void setProvided(Boolean provided) {
        this.provided = provided;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Alert> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(List<Alert> alerts) {
        this.alerts = alerts;
    }

    public List<Resource> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Resource> projects) {
        this.projects = projects;
    }

    public List<ActiveRule> getActiveRules(RuleFailureLevel level) {
        ArrayList<ActiveRule> result = new ArrayList<ActiveRule>();
        for (ActiveRule activeRule : this.getActiveRules()) {
            if (!activeRule.getLevel().equals((Object)level)) continue;
            result.add(activeRule);
        }
        return result;
    }

    public List<ActiveRule> getActiveRulesByPlugin(String pluginKey) {
        ArrayList<ActiveRule> result = new ArrayList<ActiveRule>();
        for (ActiveRule activeRule : this.getActiveRules()) {
            if (!pluginKey.equals(activeRule.getPluginName())) continue;
            result.add(activeRule);
        }
        return result;
    }

    public ActiveRule getActiveRule(String pluginKey, String ruleKey) {
        for (ActiveRule activeRule : this.getActiveRules()) {
            if (!activeRule.getRuleKey().equals(ruleKey) || !activeRule.getPluginName().equals(pluginKey)) continue;
            return activeRule;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RulesProfile)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RulesProfile other = (RulesProfile)obj;
        return new EqualsBuilder().append((Object)this.language, (Object)other.getLanguage()).append((Object)this.name, (Object)other.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.language).append((Object)this.name).toHashCode();
    }

    public Object clone() {
        RulesProfile clone = new RulesProfile(this.getName(), this.getLanguage(), this.getDefaultProfile(), this.getProvided());
        if (CollectionUtils.isNotEmpty(this.getActiveRules())) {
            clone.setActiveRules(new ArrayList<ActiveRule>(CollectionUtils.collect(this.getActiveRules(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((ActiveRule)input).clone();
                }
            })));
        }
        if (CollectionUtils.isNotEmpty(this.getAlerts())) {
            clone.setAlerts(new ArrayList<Alert>(CollectionUtils.collect(this.getAlerts(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((Alert)input).clone();
                }
            })));
        }
        if (CollectionUtils.isNotEmpty(this.getProjects())) {
            clone.setProjects(new ArrayList<Resource>(CollectionUtils.collect(this.getProjects(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((Resource)input).clone();
                }
            })));
        }
        return clone;
    }

    public String toString() {
        return this.name + ", language=" + this.language;
    }
}

