/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.sonar.api.Extension;
import org.sonar.api.Plugin;
import org.sonar.api.Plugins;
import org.sonar.api.resources.Language;
import org.sonar.api.rules.ConfigurationExportable;
import org.sonar.api.rules.ConfigurationImportable;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulesCategory;
import org.sonar.api.rules.RulesManager;
import org.sonar.api.rules.RulesRepository;
import org.sonar.jpa.dao.RulesDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefaultRulesManager
extends RulesManager {
    private final Set<Language> languages;
    private final RulesRepository<?>[] repositories;
    private final Map<Language, List<RulesRepository<?>>> rulesByLanguage;
    private final Map<Language, List<Plugin>> pluginsByLanguage;
    private final Map<String, Map<String, Rule>> rulesByPluginAndKey = new HashMap<String, Map<String, Rule>>();
    private final RulesDao rulesDao;
    private final Plugins plugins;

    public DefaultRulesManager(Plugins plugins, RulesRepository[] repositories, RulesDao dao) {
        this.plugins = plugins;
        this.rulesDao = dao;
        this.languages = new HashSet<Language>();
        this.rulesByLanguage = new HashMap();
        this.pluginsByLanguage = new HashMap<Language, List<Plugin>>();
        this.repositories = repositories;
        for (RulesRepository repository : repositories) {
            this.languages.add(repository.getLanguage());
            List<RulesRepository<?>> list = this.rulesByLanguage.get(repository.getLanguage());
            if (list == null) {
                list = new ArrayList();
                this.rulesByLanguage.put(repository.getLanguage(), list);
            }
            list.add(repository);
            List<Plugin> languagePlugins = this.pluginsByLanguage.get(repository.getLanguage());
            if (languagePlugins == null) {
                languagePlugins = new ArrayList<Plugin>();
                this.pluginsByLanguage.put(repository.getLanguage(), languagePlugins);
            }
            languagePlugins.add(plugins.getPluginByExtension((Extension)repository));
        }
    }

    protected DefaultRulesManager(RulesDao dao, Plugins plugins) {
        this.rulesDao = dao;
        this.plugins = plugins;
        this.languages = new HashSet<Language>();
        this.rulesByLanguage = new HashMap();
        this.pluginsByLanguage = new HashMap<Language, List<Plugin>>();
        this.repositories = null;
    }

    public Set<Language> getLanguages() {
        return this.languages;
    }

    public List<RulesRepository<?>> getRulesRepositories(Language language) {
        List<RulesRepository<?>> rulesRepositories = this.rulesByLanguage.get(language);
        if (CollectionUtils.isNotEmpty(rulesRepositories)) {
            return rulesRepositories;
        }
        return Collections.emptyList();
    }

    public List<RulesRepository<?>> getRulesRepositories() {
        return Arrays.asList(this.repositories);
    }

    public List<Plugin> getPlugins(Language language) {
        List<Plugin> result = this.pluginsByLanguage.get(language);
        if (!CollectionUtils.isEmpty(result)) {
            return result;
        }
        return Collections.emptyList();
    }

    public Map<String, Long> countRulesByCategory(Language language) {
        return this.countRulesByCategory(language, this.rulesDao);
    }

    protected Map<String, Long> countRulesByCategory(Language language, RulesDao rulesDao) {
        HashMap<String, Long> countByCategory = new HashMap<String, Long>();
        List<Plugin> result = this.getPlugins(language);
        if (!CollectionUtils.isEmpty(result)) {
            List<String> keys = this.getPluginKeys(this.getPlugins(language));
            for (RulesCategory rulesCategory : rulesDao.getCategories()) {
                Long rulesCount = rulesDao.countRules(keys, rulesCategory.getName());
                countByCategory.put(rulesCategory.getName(), rulesCount);
            }
        }
        return countByCategory;
    }

    private List<String> getPluginKeys(List<Plugin> plugins) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Plugin plugin : plugins) {
            keys.add(plugin.getKey());
        }
        return keys;
    }

    public List<Plugin> getExportablePlugins(Language language) {
        ArrayList<Plugin> targets = new ArrayList<Plugin>();
        List<RulesRepository<?>> rulesRepositories = this.getRulesRepositories(language);
        for (RulesRepository<?> repository : rulesRepositories) {
            if (!(repository instanceof ConfigurationExportable)) continue;
            targets.add(this.plugins.getPluginByExtension(repository));
        }
        return targets;
    }

    public List<Plugin> getImportablePlugins(Language language) {
        ArrayList<Plugin> targets = new ArrayList<Plugin>();
        for (RulesRepository<?> repository : this.getRulesRepositories(language)) {
            if (!(repository instanceof ConfigurationImportable)) continue;
            targets.add(this.plugins.getPluginByExtension(repository));
        }
        return targets;
    }

    public Map<String, Rule> getPluginRulesIndexedByKey(String pluginKey) {
        Map<String, Rule> rulesByKey = this.rulesByPluginAndKey.get(pluginKey);
        if (rulesByKey == null) {
            rulesByKey = new HashMap<String, Rule>();
            List rules = this.rulesDao.getRulesByPlugin(pluginKey);
            if (rules != null) {
                for (Rule rule : rules) {
                    rulesByKey.put(rule.getKey(), rule);
                }
            }
            this.rulesByPluginAndKey.put(pluginKey, rulesByKey);
        }
        return rulesByKey;
    }

    public Collection<Rule> getPluginRules(String pluginKey) {
        Map<String, Rule> rulesByKey = this.getPluginRulesIndexedByKey(pluginKey);
        return rulesByKey.values();
    }

    public Rule getPluginRule(String pluginKey, String ruleKey) {
        Map<String, Rule> rulesByKey = this.getPluginRulesIndexedByKey(pluginKey);
        return rulesByKey.get(ruleKey);
    }
}

