/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

@Deprecated
public abstract class AbstractFileComplexityDecorator
implements Decorator {
    private Language language;

    public AbstractFileComplexityDecorator(Language language) {
        this.language = language;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.language.equals(project.getLanguage());
    }

    @DependsUpon
    public List<Metric> dependsUponFileAndComplexityMetrics() {
        return Arrays.asList(CoreMetrics.FILES, CoreMetrics.COMPLEXITY);
    }

    @DependedUpon
    public Metric generateFileComplexityMetric() {
        return CoreMetrics.FILE_COMPLEXITY;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(resource, context)) {
            return;
        }
        Double files = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.FILES), null);
        Double complexity = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.COMPLEXITY), null);
        if (complexity != null && files != null && files > 0.0) {
            context.saveMeasure(CoreMetrics.FILE_COMPLEXITY, Double.valueOf(complexity / files));
        }
    }

    private boolean shouldDecorateResource(Resource resource, DecoratorContext context) {
        return !MeasureUtils.hasValue((Measure)context.getMeasure(CoreMetrics.FILE_COMPLEXITY)) && !ResourceUtils.isEntity((Resource)resource);
    }
}

