/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

@Deprecated
public abstract class AbstractFunctionComplexityDecorator
implements Decorator {
    private Language language;

    public AbstractFunctionComplexityDecorator(Language language) {
        this.language = language;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.language.equals(project.getLanguage());
    }

    @DependsUpon
    public List<Metric> dependsUponFileAndComplexityMetrics() {
        return Arrays.asList(CoreMetrics.FUNCTIONS, CoreMetrics.COMPLEXITY);
    }

    @DependedUpon
    public Metric generateFileComplexityMetric() {
        return CoreMetrics.FUNCTION_COMPLEXITY;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(resource, context)) {
            return;
        }
        Double functions = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.FUNCTIONS), null);
        Double complexity = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.COMPLEXITY), null);
        if (complexity != null && functions != null && functions > 0.0) {
            context.saveMeasure(CoreMetrics.FUNCTION_COMPLEXITY, Double.valueOf(complexity / functions));
        }
    }

    private boolean shouldDecorateResource(Resource resource, DecoratorContext context) {
        return !MeasureUtils.hasValue((Measure)context.getMeasure(CoreMetrics.FUNCTION_COMPLEXITY));
    }
}

