/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.util.FileFinder;
import org.sonar.duplications.cpd.FileCodeLoaderWithoutCache;
import org.sonar.duplications.cpd.Match;
import org.sonar.duplications.cpd.MatchAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CPD {
    private Map<String, SourceCode> source = new HashMap<String, SourceCode>();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private int minimumTileSize;
    private MatchAlgorithm matchAlgorithm;
    private Language language;
    private boolean loadSourceCodeSlices = true;
    private String encoding = System.getProperty("file.encoding");

    public CPD(int minimumTileSize, Language language) {
        TokenEntry.clearImages();
        this.minimumTileSize = minimumTileSize;
        this.language = language;
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLoadSourceCodeSlices(boolean loadSourceCodeSlices) {
        this.loadSourceCodeSlices = loadSourceCodeSlices;
    }

    public void go() {
        TokenEntry.clearImages();
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.minimumTileSize, this.listener);
        this.matchAlgorithm.setLoadSourceCodeSlices(this.loadSourceCodeSlices);
        this.matchAlgorithm.findMatches();
    }

    public Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void add(File file) throws IOException {
        this.add(1, file);
    }

    public void addAllInDirectory(String dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(String dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(files.size(), f);
        }
    }

    private void addDirectory(String dir, boolean recurse) throws IOException {
        if (!new File(dir).exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.language.getFileFilter(), recurse));
    }

    private void add(int fileCount, File file) throws IOException {
        if (!file.getCanonicalPath().equals(new File(file.getAbsolutePath()).getCanonicalPath())) {
            System.out.println("Skipping " + file + " since it appears to be a symlink");
            return;
        }
        this.listener.addedFile(fileCount, file);
        SourceCode sourceCode = new SourceCode(new FileCodeLoaderWithoutCache(file, this.encoding));
        this.language.getTokenizer().tokenize(sourceCode, this.tokens);
        this.source.put(sourceCode.getFileName(), sourceCode);
    }
}

