/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.detector.suffixtree.DuplicationsCollector;
import org.sonar.duplications.detector.suffixtree.Search;
import org.sonar.duplications.detector.suffixtree.TextSet;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.CloneIndex;

public final class SuffixTreeCloneDetectionAlgorithm {
    private static final Comparator<Block> BLOCK_COMPARATOR = new Comparator<Block>(){

        @Override
        public int compare(Block o1, Block o2) {
            return o1.getIndexInFile() - o2.getIndexInFile();
        }
    };

    public static List<CloneGroup> detect(CloneIndex cloneIndex, Collection<Block> fileBlocks) {
        if (fileBlocks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        TextSet text = SuffixTreeCloneDetectionAlgorithm.createTextSet(cloneIndex, fileBlocks);
        if (text == null) {
            return Collections.EMPTY_LIST;
        }
        DuplicationsCollector reporter = new DuplicationsCollector(text);
        Search.perform(text, reporter);
        return reporter.getResult();
    }

    private SuffixTreeCloneDetectionAlgorithm() {
    }

    private static TextSet createTextSet(CloneIndex index, Collection<Block> fileBlocks) {
        HashSet hashes = Sets.newHashSet();
        for (Block fileBlock : fileBlocks) {
            hashes.add(fileBlock.getBlockHash());
        }
        String originResourceId = fileBlocks.iterator().next().getResourceId();
        Map<String, List<Block>> fromIndex = SuffixTreeCloneDetectionAlgorithm.retrieveFromIndex(index, originResourceId, hashes);
        if (fromIndex.isEmpty() && hashes.size() == fileBlocks.size()) {
            return null;
        }
        return SuffixTreeCloneDetectionAlgorithm.createTextSet(fileBlocks, fromIndex);
    }

    private static TextSet createTextSet(Collection<Block> fileBlocks, Map<String, List<Block>> fromIndex) {
        TextSet.Builder textSetBuilder = TextSet.builder();
        ArrayList sortedFileBlocks = Lists.newArrayList(fileBlocks);
        Collections.sort(sortedFileBlocks, BLOCK_COMPARATOR);
        textSetBuilder.add(sortedFileBlocks);
        for (List<Block> list : fromIndex.values()) {
            Collections.sort(list, BLOCK_COMPARATOR);
            int i = 0;
            while (i < list.size()) {
                int j;
                for (j = i + 1; j < list.size() && list.get(j).getIndexInFile() == list.get(j - 1).getIndexInFile() + 1; ++j) {
                }
                textSetBuilder.add(list.subList(i, j));
                i = j;
            }
        }
        return textSetBuilder.build();
    }

    private static Map<String, List<Block>> retrieveFromIndex(CloneIndex index, String originResourceId, Set<ByteArray> hashes) {
        HashMap collection = Maps.newHashMap();
        for (ByteArray hash : hashes) {
            Collection<Block> blocks = index.getBySequenceHash(hash);
            for (Block blockFromIndex : blocks) {
                String resourceId = blockFromIndex.getResourceId();
                if (originResourceId.equals(resourceId)) continue;
                List list = (List)collection.get(resourceId);
                if (list == null) {
                    list = Lists.newArrayList();
                    collection.put(resourceId, list);
                }
                list.add(blockFromIndex);
            }
        }
        return collection;
    }
}

