/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import java.util.Arrays;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.MavenPluginExecutor;

public class Maven2PluginExecutor
implements MavenPluginExecutor {
    private LifecycleExecutor lifecycleExecutor;
    private MavenSession mavenSession;

    public Maven2PluginExecutor(LifecycleExecutor le, MavenSession mavenSession) {
        this.lifecycleExecutor = le;
        this.mavenSession = mavenSession;
    }

    public MavenPluginHandler execute(Project project, MavenPluginHandler handler) {
        for (String goal : handler.getGoals()) {
            MavenPlugin plugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)handler.getGroupId(), (String)handler.getArtifactId());
            this.execute(project, Maven2PluginExecutor.getGoal(handler.getGroupId(), handler.getArtifactId(), plugin.getPlugin().getVersion(), goal));
        }
        return handler;
    }

    public void execute(Project project, String goal) {
        try {
            ReactorManager reactor = new ReactorManager(Arrays.asList(project.getPom()));
            MavenSession clonedSession = new MavenSession(this.mavenSession.getContainer(), this.mavenSession.getSettings(), this.mavenSession.getLocalRepository(), this.mavenSession.getEventDispatcher(), reactor, Arrays.asList(goal), this.mavenSession.getExecutionRootDirectory(), this.mavenSession.getExecutionProperties(), this.mavenSession.getStartTime());
            this.lifecycleExecutor.execute(clonedSession, reactor, clonedSession.getEventDispatcher());
        }
        catch (Exception e) {
            throw new SonarException("Unable to execute maven plugin", (Throwable)e);
        }
    }

    protected static String getGoal(String groupId, String artifactId, String version, String goal) {
        String defaultVersion = version == null ? "" : version;
        return groupId + ":" + artifactId + ":" + defaultVersion + ":" + goal;
    }
}

