package org.sonar.updatecenter.mavenplugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on sonar-packaging-maven-plugin.<br/> Call <pre>  mvn sonar-packaging:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon Feb 25 16:20:23 CET 2013
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.sonar:sonar-packaging-maven-plugin:1.5-RC1", 0 );
        append( sb, "", 0 );

        append( sb, "Sonar :: Update Center :: Packaging Mojo", 0 );
        append( sb, "Sonar Update Center", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check-dependencies".equals( goal ) )
        {
            append( sb, "sonar-packaging:check-dependencies", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appDirectory", 2 );
                append( sb, "The directory where the app is built.", 3 );
                append( sb, "", 0 );

                append( sb, "basePlugin", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "classesDirectory", 2 );
                append( sb, "Directory containing the classes and resource files that should be packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "Name of the generated JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "Directory containing the generated JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginClass", 2 );
                append( sb, "Name of plugin class.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginDescription (Default: ${project.description})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginIssueTrackerUrl (Default: ${project.issueManagement.url})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginKey", 2 );
                append( sb, "Plugin key.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginName (Default: ${project.name})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginParent", 2 );
                append( sb, "Plugin parent.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginTermsConditionsUrl", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginUrl (Default: ${project.url})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "requirePlugins", 2 );
                append( sb, "Plugin\'s dependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipDependenciesPackaging", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "useChildFirstClassLoader", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "sonar-packaging:help", 0 );
            append( sb, "Display help information on sonar-packaging-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0sonar-packaging:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "sonar-plugin".equals( goal ) )
        {
            append( sb, "sonar-packaging:sonar-plugin", 0 );
            append( sb, "Build a Sonar Plugin from the current project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addMavenDescriptor", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "appDirectory", 2 );
                append( sb, "The directory where the app is built.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "basePlugin", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "classesDirectory", 2 );
                append( sb, "Directory containing the classes and resource files that should be packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "Name of the generated JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "Directory containing the generated JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginClass", 2 );
                append( sb, "Name of plugin class.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginDescription (Default: ${project.description})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginIssueTrackerUrl (Default: ${project.issueManagement.url})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginKey", 2 );
                append( sb, "Plugin key.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginName (Default: ${project.name})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginParent", 2 );
                append( sb, "Plugin parent.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginTermsConditionsUrl", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginUrl (Default: ${project.url})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "requirePlugins", 2 );
                append( sb, "Plugin\'s dependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipDependenciesPackaging", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "useChildFirstClassLoader", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
