/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.mavenplugin;

import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.sonar.updatecenter.mavenplugin.AbstractSonarPluginMojo;

public class CheckDependenciesMojo
extends AbstractSonarPluginMojo {
    private static final String[] GWT_ARTIFACT_IDS = new String[]{"gwt-user", "gwt-dev", "sonar-gwt-api"};
    private static final String[] LOG_GROUP_IDS = new String[]{"log4j", "commons-logging"};

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSkipDependenciesPackaging()) {
            this.checkApiDependency();
            this.checkLogDependencies();
            this.checkGwtDependencies();
        }
    }

    private void checkApiDependency() throws MojoExecutionException {
        Artifact sonarApi = this.getSonarPluginApiArtifact();
        if (sonarApi == null) {
            throw new MojoExecutionException("org.codehaus.sonar:sonar-plugin-api should be declared in dependencies");
        }
    }

    private void checkLogDependencies() throws MojoExecutionException {
        ArrayList<String> ids = new ArrayList<String>();
        for (Artifact dep : this.getIncludedArtifacts()) {
            if (!ArrayUtils.contains((Object[])LOG_GROUP_IDS, (Object)dep.getGroupId())) continue;
            ids.add(dep.getDependencyConflictId());
        }
        if (!ids.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Dependencies on the following log libraries should be excluded or declared with scope 'provided':").append("\n\t").append(StringUtils.join(ids, (String)", ")).append('\n');
            this.getLog().warn((CharSequence)message.toString());
        }
    }

    private void checkGwtDependencies() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Artifact dep : this.getDependencyArtifacts("compile")) {
            if (!ArrayUtils.contains((Object[])GWT_ARTIFACT_IDS, (Object)dep.getArtifactId())) continue;
            ids.add(dep.getDependencyConflictId());
        }
        if (!ids.isEmpty()) {
            this.getLog().warn((CharSequence)this.getMessage("GWT dependencies should be defined with scope 'provided':", ids));
        }
    }
}

