/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Phase(name=Phase.Name.PRE)
public abstract class AbstractSourceImporter
implements Sensor {
    private Language language;
    private boolean enabled = false;

    public AbstractSourceImporter(Language language) {
        this.language = language;
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        this.enabled = this.isEnabled(project);
        return this.language.equals(project.getLanguage());
    }

    @Override
    public void analyse(Project project, SensorContext context) {
        this.analyse(project.getFileSystem(), context);
        this.onFinished();
    }

    protected void onFinished() {
    }

    protected void analyse(ProjectFileSystem fileSystem, SensorContext context) {
        this.parseDirs(context, fileSystem.getSourceFiles(this.language), fileSystem.getSourceDirs(), false, fileSystem.getSourceCharset());
        this.parseDirs(context, fileSystem.getTestFiles(this.language), fileSystem.getTestDirs(), true, fileSystem.getSourceCharset());
    }

    protected void parseDirs(SensorContext context, List<File> files, List<File> sourceDirs, boolean unitTest, Charset sourcesEncoding) {
        for (File file : files) {
            Resource resource = this.createResource(file, sourceDirs, unitTest);
            if (resource == null) continue;
            try {
                context.index(resource);
                if (!this.enabled) continue;
                String source = FileUtils.readFileToString((File)file, (String)sourcesEncoding.name());
                context.saveSource(resource, source);
            }
            catch (Exception e) {
                throw new SonarException("Unable to read and import the source file : '" + file.getAbsolutePath() + "' with the charset : '" + sourcesEncoding.name() + "'.", e);
            }
        }
    }

    protected Resource createResource(File file, List<File> sourceDirs, boolean unitTest) {
        org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile(file, sourceDirs);
        if (resource != null) {
            resource.setLanguage(this.language);
            if (unitTest) {
                resource.setQualifier("UTS");
            }
        }
        return resource;
    }

    protected boolean isEnabled(Project project) {
        return project.getConfiguration().getBoolean("sonar.importSources", true);
    }

    public Language getLanguage() {
        return this.language;
    }
}

