/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.SonarException;

public abstract class AbstractRubyTemplate {
    private String cache = null;

    public String getTemplate() {
        String result = this.loadTemplateFromCache();
        try {
            if (result == null) {
                result = this.loadTemplateFromClasspath();
            }
            if (result == null) {
                result = this.loadTemplateFromAbsolutePath();
            }
            return result;
        }
        catch (IOException e) {
            throw new SonarException("Can not read the file " + this.getTemplatePath(), e);
        }
    }

    private String loadTemplateFromAbsolutePath() throws IOException {
        File file = new File(this.getTemplatePath());
        if (file.exists()) {
            return FileUtils.readFileToString((File)file);
        }
        throw new FileNotFoundException(this.getTemplatePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTemplateFromClasspath() throws IOException {
        InputStream input = this.getClass().getResourceAsStream(this.getTemplatePath());
        try {
            if (input != null) {
                String string = this.cache = IOUtils.toString((InputStream)input);
                return string;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return null;
    }

    protected String loadTemplateFromCache() {
        return this.cache;
    }

    protected abstract String getTemplatePath();
}

