/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDivisionDecorator
implements Decorator {
    protected abstract Metric getQuotientMetric();

    protected abstract Metric getDivisorMetric();

    protected abstract Metric getDividendMetric();

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(this.getDividendMetric(), this.getDivisorMetric());
    }

    @DependedUpon
    public Metric generatesMetric() {
        return this.getQuotientMetric();
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @Override
    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(context)) {
            return;
        }
        Measure dividend = context.getMeasure(this.getDividendMetric());
        Measure divisor = context.getMeasure(this.getDivisorMetric());
        if (MeasureUtils.hasValue(dividend) && MeasureUtils.hasValue(divisor) && divisor.getValue() > 0.0) {
            context.saveMeasure(new Measure(this.getQuotientMetric(), this.compute(dividend, divisor, this.getQuotientMetric().isPercentageType())));
        }
    }

    protected boolean shouldDecorateResource(DecoratorContext context) {
        return context.getMeasure(this.getQuotientMetric()) == null;
    }

    protected double compute(Measure dividend, Measure divisor, boolean shouldResultBeInPercent) {
        double result = dividend.getValue() / divisor.getValue();
        return shouldResultBeInPercent ? result * 100.0 : result;
    }
}

