/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;

public final class PropertyDefinition {
    private String key;
    private String defaultValue;
    private String name;
    private PropertyType type = PropertyType.STRING;
    private String[] options;
    private String description;
    private String category;
    private boolean onProject = false;
    private boolean onModule = false;
    private boolean isGlobal = true;

    private PropertyDefinition(Property annotation) {
        this.key = annotation.key();
        this.name = annotation.name();
        this.defaultValue = annotation.defaultValue();
        this.description = annotation.description();
        this.isGlobal = annotation.global();
        this.onProject = annotation.project();
        this.onModule = annotation.module();
        this.category = annotation.category();
        this.type = this.fixType(annotation.key(), annotation.type());
        this.options = annotation.options();
    }

    private PropertyType fixType(String key, PropertyType type) {
        PropertyType fix = type;
        if (type == PropertyType.STRING) {
            if (StringUtils.endsWith((String)key, (String)".password.secured")) {
                fix = PropertyType.PASSWORD;
            } else if (StringUtils.endsWith((String)key, (String)".license.secured")) {
                fix = PropertyType.LICENSE;
            }
        }
        return fix;
    }

    private PropertyDefinition(String key, PropertyType type, String[] options) {
        this.key = key;
        this.type = type;
        this.options = options;
    }

    public static PropertyDefinition create(Property annotation) {
        return new PropertyDefinition(annotation);
    }

    public static PropertyDefinition create(String key, PropertyType type, String[] options) {
        return new PropertyDefinition(key, type, options);
    }

    public Result validate(@Nullable String value) {
        Result result = Result.SUCCESS;
        if (StringUtils.isNotBlank((String)value)) {
            if (this.type == PropertyType.BOOLEAN) {
                if (!StringUtils.equalsIgnoreCase((String)value, (String)"true") && !StringUtils.equalsIgnoreCase((String)value, (String)"false")) {
                    result = Result.newError("notBoolean");
                }
            } else if (this.type == PropertyType.INTEGER) {
                if (!NumberUtils.isDigits((String)value)) {
                    result = Result.newError("notInteger");
                }
            } else if (this.type == PropertyType.FLOAT) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    result = Result.newError("notFloat");
                }
            } else if (this.type == PropertyType.SINGLE_SELECT_LIST && !ArrayUtils.contains((Object[])this.options, (Object)value)) {
                result = Result.newError("notInOptions");
            }
        }
        return result;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    public String[] getOptions() {
        return (String[])this.options.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isOnProject() {
        return this.onProject;
    }

    public boolean isOnModule() {
        return this.onModule;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public static final class Result {
        private static final Result SUCCESS = new Result(null);
        private String errorKey = null;

        private static Result newError(String key) {
            return new Result(key);
        }

        @Nullable
        private Result(@Nullable String errorKey) {
            this.errorKey = errorKey;
        }

        public boolean isValid() {
            return StringUtils.isBlank((String)this.errorKey);
        }

        @Nullable
        public String getErrorKey() {
            return this.errorKey;
        }
    }
}

