/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    private String executable;
    private List<String> arguments = Lists.newArrayList();
    private File directory;
    private Map<String, String> env = Maps.newHashMap(System.getenv());

    private Command(String executable) {
        this.executable = executable;
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public Command addArgument(String arg) {
        this.arguments.add(arg);
        return this;
    }

    public Command addArguments(List<String> args) {
        this.arguments.addAll(args);
        return this;
    }

    public Command addArguments(String[] args) {
        this.arguments.addAll(Arrays.asList(args));
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Command setDirectory(File d) {
        this.directory = d;
        return this;
    }

    public Command setEnvironmentVariable(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.env);
    }

    String[] toStrings() {
        ArrayList command = Lists.newArrayList();
        command.add(this.executable);
        command.addAll(this.arguments);
        return command.toArray(new String[command.size()]);
    }

    public String toCommandLine() {
        return Joiner.on((String)" ").join((Object[])this.toStrings());
    }

    public String toString() {
        return this.toCommandLine();
    }

    public static Command create(String executable) {
        if (StringUtils.isBlank((String)executable)) {
            throw new IllegalArgumentException("Command executable can not be blank");
        }
        return new Command(executable);
    }
}

