/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.workflow.condition;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.workflow.Review;
import org.sonar.api.workflow.WorkflowContext;
import org.sonar.api.workflow.condition.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class ResolutionCondition
extends Condition {
    private final Set<String> resolutions;

    public ResolutionCondition(Set<String> resolutions) {
        super(false);
        Preconditions.checkNotNull(resolutions);
        Preconditions.checkArgument((!resolutions.isEmpty() ? 1 : 0) != 0, (Object)"No resolutions defined");
        this.resolutions = resolutions;
    }

    public ResolutionCondition(String ... resolutions) {
        this(Sets.newLinkedHashSet(Arrays.asList(resolutions)));
    }

    @Override
    public boolean doVerify(@Nullable Review review, WorkflowContext context) {
        return review != null && this.resolutions.contains(review.getResolution());
    }

    @VisibleForTesting
    Set<String> getResolutions() {
        return ImmutableSet.copyOf(this.resolutions);
    }
}

