/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFilePredicates;
import org.sonar.api.batch.fs.internal.FileIndex;
import org.sonar.api.batch.fs.internal.UniqueIndexPredicate;

public class DefaultFileSystem
implements FileSystem {
    private final Cache cache;
    private final SortedSet<String> languages = Sets.newTreeSet();
    private File baseDir;
    private File workDir;
    private Charset encoding;
    private final FilePredicates predicates = new DefaultFilePredicates();

    public DefaultFileSystem() {
        this.cache = new MapCache();
    }

    protected DefaultFileSystem(Cache cache) {
        this.cache = cache;
    }

    public DefaultFileSystem setBaseDir(File d) {
        Preconditions.checkNotNull((Object)d, (Object)"Base directory can't be null");
        this.baseDir = d.getAbsoluteFile();
        return this;
    }

    @Override
    public File baseDir() {
        return this.baseDir;
    }

    public DefaultFileSystem setEncoding(@Nullable Charset e) {
        this.encoding = e;
        return this;
    }

    @Override
    public Charset encoding() {
        return this.encoding == null ? Charset.defaultCharset() : this.encoding;
    }

    public boolean isDefaultJvmEncoding() {
        return this.encoding == null;
    }

    public DefaultFileSystem setWorkDir(File d) {
        this.workDir = d.getAbsoluteFile();
        return this;
    }

    @Override
    public File workDir() {
        return this.workDir;
    }

    @Override
    public InputFile inputFile(FilePredicate predicate) {
        this.doPreloadFiles();
        if (predicate instanceof UniqueIndexPredicate) {
            return this.cache.inputFile((UniqueIndexPredicate)((Object)predicate));
        }
        try {
            Iterable<InputFile> files = this.inputFiles(predicate);
            return (InputFile)Iterables.getOnlyElement(files);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate predicate) {
        this.doPreloadFiles();
        return Iterables.filter(this.cache.inputFiles(), (Predicate)new GuavaPredicate(predicate));
    }

    @Override
    public boolean hasFiles(FilePredicate predicate) {
        this.doPreloadFiles();
        return Iterables.indexOf(this.cache.inputFiles(), (Predicate)new GuavaPredicate(predicate)) >= 0;
    }

    @Override
    public Iterable<File> files(FilePredicate predicate) {
        this.doPreloadFiles();
        return Iterables.transform(this.inputFiles(predicate), (Function)new Function<InputFile, File>(){

            public File apply(@Nullable InputFile input) {
                return input == null ? null : input.file();
            }
        });
    }

    public DefaultFileSystem add(InputFile inputFile) {
        this.cache.add(inputFile);
        if (inputFile.language() != null) {
            this.languages.add(inputFile.language());
        }
        return this;
    }

    public DefaultFileSystem addLanguages(String language, String ... others) {
        this.languages.add(language);
        Collections.addAll(this.languages, others);
        return this;
    }

    @Override
    public SortedSet<String> languages() {
        this.doPreloadFiles();
        return this.languages;
    }

    @Override
    public FilePredicates predicates() {
        return this.predicates;
    }

    protected void doPreloadFiles() {
    }

    private static class GuavaPredicate
    implements Predicate<InputFile> {
        private final FilePredicate predicate;

        private GuavaPredicate(FilePredicate predicate) {
            this.predicate = predicate;
        }

        public boolean apply(@Nullable InputFile input) {
            return input != null && this.predicate.apply(input);
        }
    }

    private static class MapCache
    extends Cache {
        private final List<InputFile> files = Lists.newArrayList();
        private final Map<String, Map<Object, InputFile>> fileMap = Maps.newHashMap();

        private MapCache() {
        }

        @Override
        public Iterable<InputFile> inputFiles() {
            return Lists.newArrayList(this.files);
        }

        @Override
        public InputFile inputFile(UniqueIndexPredicate predicate) {
            Map<Object, InputFile> byAttr = this.fileMap.get(predicate.indexId());
            if (byAttr != null) {
                return byAttr.get(predicate.value());
            }
            return null;
        }

        @Override
        protected void doAdd(InputFile inputFile) {
            this.files.add(inputFile);
        }

        @Override
        protected void doIndex(String indexId, Object value, InputFile inputFile) {
            HashMap attrValues = this.fileMap.get(indexId);
            if (attrValues == null) {
                attrValues = Maps.newHashMap();
                this.fileMap.put(indexId, attrValues);
            }
            attrValues.put(value, inputFile);
        }
    }

    public static abstract class Cache {
        protected abstract Iterable<InputFile> inputFiles();

        @CheckForNull
        protected abstract InputFile inputFile(UniqueIndexPredicate var1);

        protected abstract void doAdd(InputFile var1);

        protected abstract void doIndex(String var1, Object var2, InputFile var3);

        final void add(InputFile inputFile) {
            this.doAdd(inputFile);
            for (FileIndex index : FileIndex.ALL) {
                this.doIndex(index.id(), index.valueOf(inputFile), inputFile);
            }
        }
    }
}

