/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.maven;

import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.maven.MavenPlugin;

public final class MavenUtils {
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    public static final String GROUP_ID_APACHE_MAVEN = "org.apache.maven.plugins";
    public static final String GROUP_ID_CODEHAUS_MOJO = "org.codehaus.mojo";

    private MavenUtils() {
    }

    public static String getJavaVersion(MavenProject pom) {
        MavenPlugin compilerPlugin = MavenPlugin.getPlugin(pom, GROUP_ID_APACHE_MAVEN, MAVEN_COMPILER_PLUGIN);
        if (compilerPlugin != null) {
            return compilerPlugin.getParameter("target");
        }
        return null;
    }

    public static String getJavaSourceVersion(MavenProject pom) {
        MavenPlugin compilerPlugin = MavenPlugin.getPlugin(pom, GROUP_ID_APACHE_MAVEN, MAVEN_COMPILER_PLUGIN);
        if (compilerPlugin != null) {
            return compilerPlugin.getParameter("source");
        }
        return null;
    }

    public static Plugin getPlugin(Collection<Plugin> plugins, String groupId, String artifactId) {
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!MavenUtils.equals(plugin, groupId, artifactId)) continue;
                return plugin;
            }
        }
        return null;
    }

    public static boolean equals(Plugin plugin, String groupId, String artifactId) {
        if (plugin != null && plugin.getArtifactId().equals(artifactId)) {
            if (plugin.getGroupId() == null) {
                return groupId == null || groupId.equals(GROUP_ID_APACHE_MAVEN) || groupId.equals(GROUP_ID_CODEHAUS_MOJO);
            }
            return plugin.getGroupId().equals(groupId);
        }
        return false;
    }

    public static boolean equals(ReportPlugin plugin, String groupId, String artifactId) {
        if (plugin != null && plugin.getArtifactId().equals(artifactId)) {
            if (plugin.getGroupId() == null) {
                return groupId == null || groupId.equals(GROUP_ID_APACHE_MAVEN) || groupId.equals(GROUP_ID_CODEHAUS_MOJO);
            }
            return plugin.getGroupId().equals(groupId);
        }
        return false;
    }

    public static String getSourceEncoding(MavenProject pom) {
        return pom.getProperties().getProperty("project.build.sourceEncoding");
    }

    public static Charset getSourceCharset(MavenProject pom) {
        String encoding = MavenUtils.getSourceEncoding(pom);
        if (StringUtils.isNotEmpty((String)encoding)) {
            try {
                return Charset.forName(encoding);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MavenUtils.class).warn("Can not get project charset", (Throwable)e);
            }
        }
        return Charset.defaultCharset();
    }
}

