/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRules;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

public class ActiveRulesBuilder {
    private final Map<RuleKey, NewActiveRule> map = Maps.newHashMap();

    public NewActiveRule activate(RuleKey ruleKey) {
        if (this.map.containsKey(ruleKey)) {
            throw new IllegalStateException(String.format("Rule '%s' is already activated", ruleKey));
        }
        NewActiveRule newActiveRule = new NewActiveRule(ruleKey);
        this.map.put(ruleKey, newActiveRule);
        return newActiveRule;
    }

    public ActiveRules build() {
        return new DefaultActiveRules(this.map.values());
    }
}

