/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

@Immutable
class DefaultActiveRules
implements ActiveRules {
    private final ListMultimap<String, ActiveRule> activeRulesByRepository;

    public DefaultActiveRules(Collection<NewActiveRule> newActiveRules) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (NewActiveRule newAR : newActiveRules) {
            DefaultActiveRule ar = new DefaultActiveRule(newAR);
            builder.put((Object)ar.ruleKey().repository(), (Object)ar);
        }
        this.activeRulesByRepository = builder.build();
    }

    @Override
    public ActiveRule find(RuleKey ruleKey) {
        List rules = this.activeRulesByRepository.get((Object)ruleKey.repository());
        for (ActiveRule rule : rules) {
            if (!StringUtils.equals((String)rule.ruleKey().rule(), (String)ruleKey.rule())) continue;
            return rule;
        }
        return null;
    }

    @Override
    public Collection<ActiveRule> findAll() {
        return this.activeRulesByRepository.values();
    }

    @Override
    public Collection<ActiveRule> findByRepository(String repository) {
        return this.activeRulesByRepository.get((Object)repository);
    }
}

