/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.design;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Resource;
import org.sonar.graph.Edge;

public class Dependency
implements Edge<Resource> {
    private Resource from;
    private Resource to;
    private String usage;
    private int weight;
    private Dependency parent;
    private Long id;

    public Dependency(Resource from, Resource to) {
        if (from == null) {
            throw new IllegalArgumentException("Dependency source is null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Dependency target is null");
        }
        this.from = from;
        this.to = to;
    }

    public Resource getFrom() {
        return this.from;
    }

    public Resource getTo() {
        return this.to;
    }

    public String getUsage() {
        return this.usage;
    }

    public Dependency setUsage(String usage) {
        this.usage = usage;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public Dependency setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public Dependency getParent() {
        return this.parent;
    }

    public Dependency setParent(Dependency parent) {
        this.parent = parent;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public Dependency setId(Long id) {
        this.id = id;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Dependency)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Dependency other = (Dependency)obj;
        return new EqualsBuilder().append((Object)this.from, (Object)other.from).append((Object)this.to, (Object)other.to).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.from).append((Object)this.to).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("from", (Object)this.from).append("to", (Object)this.to).append("weight", this.weight).append("usage", (Object)this.usage).toString();
    }
}

