/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.BatchExtension;
import org.sonar.api.ServerExtension;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.measures.Formula;

@Table(name="metrics")
@Entity(name="Metric")
@InstantiationStrategy(value="PER_BATCH")
public class Metric
implements ServerExtension,
BatchExtension {
    public static final int DIRECTION_WORST = -1;
    public static final int DIRECTION_BETTER = 1;
    public static final int DIRECTION_NONE = 0;
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @Transient
    private Formula formula;
    @Column(name="name", updatable=false, nullable=false, length=64)
    private String key;
    @Column(name="description", updatable=true, nullable=true, length=255)
    private String description;
    @Column(name="val_type", updatable=true, nullable=true)
    @Enumerated(value=EnumType.STRING)
    private ValueType type;
    @Column(name="direction", updatable=true, nullable=true)
    private Integer direction;
    @Column(name="domain", updatable=true, nullable=true, length=60)
    private String domain;
    @Column(name="short_name", updatable=true, nullable=true, length=64)
    private String name;
    @Column(name="qualitative", updatable=true, nullable=true)
    private Boolean qualitative = Boolean.FALSE;
    @Column(name="user_managed", updatable=true, nullable=true)
    private Boolean userManaged = Boolean.FALSE;
    @Column(name="enabled", updatable=true, nullable=true)
    private Boolean enabled = Boolean.TRUE;
    @Column(name="origin", updatable=true, nullable=true, length=3)
    @Enumerated(value=EnumType.STRING)
    private Origin origin = Origin.JAV;
    @Column(name="worst_value", updatable=true, nullable=true, precision=30, scale=20)
    private Double worstValue;
    @Column(name="best_value", updatable=true, nullable=true, precision=30, scale=20)
    private Double bestValue;
    @Column(name="optimized_best_value", updatable=true, nullable=true)
    private Boolean optimizedBestValue;
    @Column(name="hidden", updatable=true, nullable=true)
    private Boolean hidden = Boolean.FALSE;
    @Column(name="delete_historical_data", updatable=true, nullable=true)
    private Boolean deleteHistoricalData;

    private Metric(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.direction = builder.direction;
        this.domain = builder.domain;
        this.qualitative = builder.qualitative;
        this.enabled = Boolean.TRUE;
        this.worstValue = builder.worstValue;
        this.optimizedBestValue = builder.optimizedBestValue;
        this.bestValue = builder.bestValue;
        this.hidden = builder.hidden;
        this.formula = builder.formula;
        this.userManaged = builder.userManaged;
        this.deleteHistoricalData = builder.deleteHistoricalData;
    }

    @Deprecated
    public Metric() {
    }

    @Deprecated
    public Metric(String key) {
        this(key, ValueType.INT);
    }

    @Deprecated
    public Metric(String key, ValueType type) {
        this(key, key, key, type, -1, Boolean.FALSE, null, false);
    }

    @Deprecated
    public Metric(String key, String name, String description, ValueType type, Integer direction, Boolean qualitative, String domain) {
        this(key, name, description, type, direction, qualitative, domain, false);
    }

    @Deprecated
    public Metric(String key, String name, String description, ValueType type, Integer direction, Boolean qualitative, @Nullable String domain, boolean userManaged) {
        this.key = key;
        this.description = description;
        this.type = type;
        this.direction = direction;
        this.domain = domain;
        this.name = name;
        this.qualitative = qualitative;
        this.userManaged = userManaged;
        this.origin = Origin.JAV;
        if (ValueType.PERCENT.equals((Object)this.type)) {
            this.bestValue = direction == 1 ? 100.0 : 0.0;
            this.worstValue = direction == 1 ? 0.0 : 100.0;
        }
    }

    @Deprecated
    public Metric(String key, String name, ValueType type, Integer direction, Boolean qualitative, String domain, Formula formula) {
        this.key = key;
        this.name = name;
        this.type = type;
        this.direction = direction;
        this.domain = domain;
        this.qualitative = qualitative;
        this.origin = Origin.JAV;
        this.enabled = true;
        this.userManaged = false;
        this.formula = formula;
        if (ValueType.PERCENT.equals((Object)this.type)) {
            this.bestValue = direction == 1 ? 100.0 : 0.0;
            this.worstValue = direction == 1 ? 0.0 : 100.0;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public Metric setId(@Nullable Integer id) {
        this.id = id;
        return this;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public Metric setFormula(Formula formula) {
        this.formula = formula;
        return this;
    }

    public Boolean getQualitative() {
        return this.qualitative;
    }

    public Metric setQualitative(Boolean qualitative) {
        this.qualitative = qualitative;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Metric setKey(String key) {
        this.key = key;
        return this;
    }

    public ValueType getType() {
        return this.type;
    }

    public Metric setType(ValueType type) {
        this.type = type;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Metric setDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean getUserManaged() {
        return this.userManaged;
    }

    public Metric setUserManaged(Boolean userManaged) {
        this.userManaged = userManaged;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Metric setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getDirection() {
        return this.direction;
    }

    public Metric setDirection(Integer direction) {
        this.direction = direction;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public Metric setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Metric setName(String name) {
        this.name = name;
        return this;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Metric setOrigin(Origin origin) {
        this.origin = origin;
        return this;
    }

    public Double getWorstValue() {
        return this.worstValue;
    }

    public Double getBestValue() {
        return this.bestValue;
    }

    public Metric setWorstValue(Double d) {
        this.worstValue = d;
        return this;
    }

    public Metric setBestValue(Double bestValue) {
        this.bestValue = bestValue;
        return this;
    }

    public boolean isNumericType() {
        return ValueType.INT.equals((Object)this.type) || ValueType.FLOAT.equals((Object)this.type) || ValueType.PERCENT.equals((Object)this.type) || ValueType.BOOL.equals((Object)this.type) || ValueType.MILLISEC.equals((Object)this.type) || ValueType.RATING.equals((Object)this.type) || ValueType.WORK_DUR.equals((Object)this.type);
    }

    public boolean isDataType() {
        return ValueType.DATA.equals((Object)this.type) || ValueType.DISTRIB.equals((Object)this.type);
    }

    public boolean isPercentageType() {
        return ValueType.PERCENT.equals((Object)this.type);
    }

    public Metric setOptimizedBestValue(Boolean b) {
        this.optimizedBestValue = b;
        return this;
    }

    public Boolean isOptimizedBestValue() {
        return this.optimizedBestValue;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public Metric setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Boolean getDeleteHistoricalData() {
        return this.deleteHistoricalData;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metric)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Metric other = (Metric)obj;
        return this.key.equals(other.getKey());
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public Metric merge(Metric with) {
        this.description = with.description;
        this.domain = with.domain;
        this.enabled = with.enabled;
        this.qualitative = with.qualitative;
        this.worstValue = with.worstValue;
        this.bestValue = with.bestValue;
        this.optimizedBestValue = with.optimizedBestValue;
        this.direction = with.direction;
        this.key = with.key;
        this.type = with.type;
        this.name = with.name;
        this.userManaged = with.userManaged;
        this.origin = with.origin;
        this.hidden = with.hidden;
        this.deleteHistoricalData = with.deleteHistoricalData;
        return this;
    }

    public static final class Builder {
        private String key;
        private ValueType type;
        private String name;
        private String description;
        private Integer direction = 0;
        private Boolean qualitative = Boolean.FALSE;
        private String domain = null;
        private Formula formula;
        private Double worstValue;
        private Double bestValue;
        private boolean optimizedBestValue = false;
        private boolean hidden = false;
        private boolean userManaged = false;
        private boolean deleteHistoricalData = false;

        public Builder(String key, String name, ValueType type) {
            if (StringUtils.isBlank((String)key)) {
                throw new IllegalArgumentException("Metric key can not be blank");
            }
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("Metric name can not be blank");
            }
            if (type == null) {
                throw new IllegalArgumentException("Metric type can not be null");
            }
            this.key = key;
            this.name = name;
            this.type = type;
        }

        public Builder setDescription(String d) {
            this.description = d;
            return this;
        }

        public Builder setDirection(Integer d) {
            this.direction = d;
            return this;
        }

        public Builder setQualitative(Boolean b) {
            this.qualitative = b;
            return this;
        }

        public Builder setDomain(String d) {
            this.domain = d;
            return this;
        }

        public Builder setFormula(Formula f) {
            this.formula = f;
            return this;
        }

        public Builder setWorstValue(Double d) {
            this.worstValue = d;
            return this;
        }

        public Builder setBestValue(Double d) {
            this.bestValue = d;
            return this;
        }

        public Builder setOptimizedBestValue(boolean b) {
            this.optimizedBestValue = b;
            return this;
        }

        public Builder setHidden(boolean b) {
            this.hidden = b;
            return this;
        }

        public Builder setUserManaged(boolean b) {
            this.userManaged = b;
            return this;
        }

        public Builder setDeleteHistoricalData(boolean b) {
            this.deleteHistoricalData = b;
            return this;
        }

        public Metric create() {
            if (ValueType.PERCENT.equals((Object)this.type)) {
                this.bestValue = this.direction == 1 ? 100.0 : 0.0;
                this.worstValue = this.direction == 1 ? 0.0 : 100.0;
            }
            return new Metric(this);
        }
    }

    public static enum Origin {
        JAV,
        GUI,
        WS;

    }

    public static enum Level {
        OK("Green"),
        WARN("Orange"),
        ERROR("Red");

        private String colorName;

        private Level(String colorName) {
            this.colorName = colorName;
        }

        public String getColorName() {
            return this.colorName;
        }
    }

    public static enum ValueType {
        INT,
        FLOAT,
        PERCENT,
        BOOL,
        STRING,
        MILLISEC,
        DATA,
        LEVEL,
        DISTRIB,
        RATING,
        WORK_DUR;

    }
}

