/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.WebService;

public abstract class Request {
    public abstract WebService.Action action();

    public abstract String method();

    public String mandatoryParam(String key) {
        String value = this.param(key);
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(String.format("Parameter '%s' is missing", key));
        }
        return value;
    }

    public boolean mandatoryParamAsBoolean(String key) {
        String s = this.mandatoryParam(key);
        return Boolean.parseBoolean(s);
    }

    public int mandatoryParamAsInt(String key) {
        String s = this.mandatoryParam(key);
        return Integer.parseInt(s);
    }

    public long mandatoryParamAsLong(String key) {
        String s = this.mandatoryParam(key);
        return Long.parseLong(s);
    }

    @CheckForNull
    public abstract String param(String var1);

    @CheckForNull
    public String param(String key, @CheckForNull String defaultValue) {
        return StringUtils.defaultString((String)this.param(key), (String)defaultValue);
    }

    @CheckForNull
    public Integer paramAsInt(String key) {
        String s = this.param(key);
        return s == null ? null : Integer.valueOf(Integer.parseInt(s));
    }

    public int paramAsInt(String key, int defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Integer.parseInt(s);
    }

    @CheckForNull
    public Long paramAsLong(String key) {
        String s = this.param(key);
        return s == null ? null : Long.valueOf(Long.parseLong(s));
    }

    public long paramAsLong(String key, long defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Long.parseLong(s);
    }

    @CheckForNull
    public Boolean paramAsBoolean(String key) {
        String s = this.param(key);
        return s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
    }

    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Boolean.parseBoolean(s);
    }
}

