/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;

public class TimeMachineQuery {
    private Resource resource;
    private List<Metric> metrics;
    private List<String> metricKeys;
    private Date from;
    private Date to;
    private boolean onlyLastAnalysis = false;
    private boolean fromCurrentAnalysis = false;
    private boolean toCurrentAnalysis = false;

    public TimeMachineQuery(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public TimeMachineQuery setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public TimeMachineQuery setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
        this.metricKeys = Lists.newLinkedList();
        for (Metric metric : this.metrics) {
            this.metricKeys.add(metric.getKey());
        }
        return this;
    }

    public TimeMachineQuery setMetricKeys(String ... metricKeys) {
        this.metricKeys = Arrays.asList(metricKeys);
        return this;
    }

    public List<String> getMetricKeys() {
        return this.metricKeys;
    }

    public TimeMachineQuery setMetricKeys(List<String> metricKeys) {
        this.metricKeys = metricKeys;
        return this;
    }

    public TimeMachineQuery setMetrics(Metric ... metrics) {
        this.metrics = Arrays.asList(metrics);
        this.metricKeys = Lists.newLinkedList();
        for (Metric metric : this.metrics) {
            this.metricKeys.add(metric.getKey());
        }
        return this;
    }

    public TimeMachineQuery unsetMetrics() {
        this.metrics = null;
        return this;
    }

    public Date getFrom() {
        return this.from;
    }

    public TimeMachineQuery setFrom(Date from) {
        this.from = from;
        return this;
    }

    public TimeMachineQuery setFromCurrentAnalysis(boolean b) {
        this.fromCurrentAnalysis = b;
        return this;
    }

    public TimeMachineQuery setToCurrentAnalysis(boolean b) {
        this.toCurrentAnalysis = b;
        return this;
    }

    public boolean isFromCurrentAnalysis() {
        return this.fromCurrentAnalysis;
    }

    public boolean isToCurrentAnalysis() {
        return this.toCurrentAnalysis;
    }

    public Date getTo() {
        return this.to;
    }

    public TimeMachineQuery setTo(Date to) {
        this.to = to;
        return this;
    }

    public boolean isOnlyLastAnalysis() {
        return this.onlyLastAnalysis;
    }

    public TimeMachineQuery setOnlyLastAnalysis(boolean onlyLastAnalysis) {
        this.onlyLastAnalysis = onlyLastAnalysis;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("resource", (Object)this.resource).append("metrics", this.metrics).append("from", (Object)this.from).append("to", (Object)this.to).toString();
    }
}

