/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.utils.PathUtils;

public class DefaultInputDir
implements InputDir,
Serializable {
    private final String relativePath;
    private String absolutePath;
    private String key;

    public DefaultInputDir(String relativePath) {
        this.relativePath = PathUtils.sanitize(relativePath);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    @CheckForNull
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public File file() {
        if (this.absolutePath == null) {
            throw new IllegalStateException("Can not return the java.io.File because absolute path is not set (see method setFile(java.io.File))");
        }
        return new File(this.absolutePath);
    }

    @CheckForNull
    public String key() {
        return this.key;
    }

    public DefaultInputDir setAbsolutePath(String s) {
        this.absolutePath = PathUtils.sanitize(s);
        return this;
    }

    public DefaultInputDir setFile(File file) {
        this.setAbsolutePath(file.getAbsolutePath());
        return this;
    }

    public DefaultInputDir setKey(String s) {
        this.key = s;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInputDir)) {
            return false;
        }
        DefaultInputDir that = (DefaultInputDir)o;
        return this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return this.relativePath.hashCode();
    }

    public String toString() {
        return "[relative=" + this.relativePath + ", abs=" + this.absolutePath + "]";
    }
}

