/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.DefaultRule;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.rule.RuleKey;

@Immutable
class DefaultRules
implements Rules {
    private final ListMultimap<String, Rule> rulesByRepository;

    DefaultRules(Collection<NewRule> newRules) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (NewRule newRule : newRules) {
            DefaultRule r = new DefaultRule(newRule);
            builder.put((Object)r.key().repository(), (Object)r);
        }
        this.rulesByRepository = builder.build();
    }

    @Override
    public Rule find(RuleKey ruleKey) {
        List rules = this.rulesByRepository.get((Object)ruleKey.repository());
        for (Rule rule : rules) {
            if (!StringUtils.equals((String)rule.key().rule(), (String)ruleKey.rule())) continue;
            return rule;
        }
        return null;
    }

    @Override
    public Collection<Rule> findAll() {
        return this.rulesByRepository.values();
    }

    @Override
    public Collection<Rule> findByRepository(String repository) {
        return this.rulesByRepository.get((Object)repository);
    }
}

